% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_write_catalog.R
\name{ReadCatalog}
\alias{ReadCatalog}
\title{Read catalog}
\usage{
ReadCatalog(
  file,
  ref.genome = NULL,
  region = "unknown",
  catalog.type = "counts",
  strict = NULL,
  stop.on.error = TRUE
)
}
\arguments{
\item{file}{Path to a catalog on disk in a standardized format.
The recognized formats are:
\itemize{
\item ICAMS formatted SBS96, SBS192, SBS1536, DBS78, DBS136, DBS144, ID, ID166
(see \code{\link{CatalogRowOrder}}).
\item SigProfiler-formatted SBS96, DBS78 and ID83 catalogs;
see \url{https://github.com/AlexandrovLab/SigProfilerExtractor}.
\item COSMIC-formatted SBS96, SBS192 (a.k.a. TSB192),
DBS78, ID83 catalogs;
see \url{https://cancer.sanger.ac.uk/signatures/}.
}}

\item{ref.genome}{A \code{ref.genome} argument as described in
\code{\link{ICAMS}}.}

\item{region}{region A character string designating a genomic region;
see \code{\link{as.catalog}} and \code{\link{ICAMS}}.}

\item{catalog.type}{One of "counts", "density", "counts.signature",
"density.signature".}

\item{strict}{Ignored and deprecated.}

\item{stop.on.error}{If TRUE, call \code{stop} on error; otherwise
return a 1-column matrix of NA's with the attribute "error"
containing error information. The number of rows may not
be the correct number for the expected catalog type.}
}
\value{
A catalog as an S3 object; see \code{\link{as.catalog}}.
}
\description{
Read a catalog in standardized format from path.
}
\details{
See also \code{\link{WriteCatalog}}
}
\note{
In ID (small insertions and deletions) catalogs, deletion repeat sizes
range from 0 to 5+, but for plotting and end-user documentation
deletion repeat sizes range from 1 to 6+.
}
\section{Comments}{

To add or change attributes of the catalog, you can use function
\code{\link[base]{attr}}. \cr For example, \code{attr(catalog, "abundance")
<- custom.abundance}.
}

\examples{
file <- system.file("extdata",
                    "strelka.regress.cat.sbs.96.csv",
                    package = "ICAMS")
catSBS96 <- ReadCatalog(file)

}
