% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixture_kurtosis.R
\name{mixture_kurtosis}
\alias{mixture_kurtosis}
\title{mixture_kurtosis.R}
\usage{
mixture_kurtosis(tempDF1, tempDF2, v1, a1, a2)
}
\arguments{
\item{tempDF1}{Generally the bootstrapped kurtosis of the mixture of chi-squares in kappa.}

\item{tempDF2}{Generally 1 because it's for the chi-square1 RV in kappa.}

\item{v1}{Generally the variance of the mixture of chi-squares plus the variance of zeta in kappa.}

\item{a1}{Generally the 1-rho in front of the first part of the kappa term.}

\item{a2}{Generally the tau(rho) term in front of the chi-square1 RV in kappa.}
}
\value{
Kurtosis (excess kurtosis to be more precise), use df = 12 / kurtosis.
}
\description{
Calculate the kurtosis of Qrho when performing SKATO with bootstrapped moments. This function is
included to allow for the potential to match the SKAT package, however we generally don't call it
because we can just bootstrap the kurtosis of Qrho directly if we are already doing bootstrap,
thus avoiding this calculation. Also it's only used in calculating the qmin values, not in
the final p-value calculation, which uses a kappa expression that is only the first two terms of Qrho.
}
