% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R
\name{dbeta_box}
\alias{dbeta_box}
\title{Density of a Beta distribution on a bounded interval}
\usage{
dbeta_box(x, shape1, shape2, a, b, log = FALSE)
}
\arguments{
\item{x}{A numeric vector of quantiles.}

\item{shape1, shape2}{non-negative parameters of the Beta distribution.}

\item{a}{The lower bound of the interval.}

\item{b}{The upper bound of the interval.}

\item{log}{Logical; if TRUE, probabilities p are given as log(p).}
}
\value{
A numeric vector of density values.
}
\description{
Density of a Beta distribution on a bounded interval
}
\examples{
# Beta(2,5) on (0,100)
x <- seq(0, 100, length.out = 100)
y <- dbeta_box(x, shape1 = 2, shape2 = 5, a = 0, b = 100)
plot(x, y, type = "l", main = "Beta(2,5) on (0,100)")

# Beta(1,1) i.e. uniform on (-1, 1)
x <- seq(-1, 1, length.out = 100)
y <- dbeta_box(x, shape1 = 1, shape2 = 1, a = -1, b = 1)
plot(x, y, type = "l", main = "Beta(1,1) on (-1,1)")
}
