% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-covid19.R
\docType{data}
\name{covid19}
\alias{covid19}
\title{My dataset from CSV}
\format{
A data frame with the following variables:
\describe{
\item{total_deaths_per_million}{Number of deaths per million inhabitants as of April 22, 2020.}
\item{country}{The name of the country.}
\item{Cal2013}{Daily caloric intake.}
\item{ca2014}{Per capita CO2 emissions in 2014.}
\item{BMI}{Body mass index in 2016 (male population).}
\item{Sras}{Number of people who died of SARS in 2004.}
\item{dtp3_2011}{Proportion of children under one year of age vaccinated with the DTP vaccine
(diphtheria, tetanus, poliomyelitis) in 2011.}
\item{BCG_policy}{BCG vaccination policy: \code{"current"}, \code{"never"} or \code{"interrupted"}.}
\item{lati}{Latitude of the country's capital.}
\item{longi}{Longitude of the country's capital.}
\item{Trade2018}{Imported and exported goods as a percentage of GDP in 2018.}
\item{H2015}{Health expenditure per capita in 2015.}
\item{Health2010}{Percentage of the state budget allocated to health in 2010.}
\item{TB}{Number of tuberculosis cases per 100,000 inhabitants.}
\item{PIBhab}{GDP per capita.}
\item{Superf}{Area of the country.}
\item{Demo}{Democracy index of the country.}
\item{HDI_2018}{Human Development Index in 2018.}
\item{Expectancy}{Life expectancy at birth.}
\item{Children}{Number of children per woman.}
\item{PopulationD}{Population density of the country.}
\item{Pop}{Total population of the country.number of children per woman}
\item{Gini}{Measure of income inequality (0 = perfect equality, 1 = perfect inequality).}
\item{AgeMed}{Median age of the population.}
\item{debut}{Number of days between the first confirmed Covid-19 case in China and the first
confirmed case in the country.}
}
}
\source{
Various international public databases (WHO, World Bank, etc.)
}
\usage{
data(covid19)
}
\description{
This dataset was imported from a CSV file and included in the IPAG package for demonstration. The reference article is
Escobar, L. E., Molina-Cruz, A., & Barillas-Mury, C. (2020). BCG
vaccine protection from severe coronavirus disease 2019 (COVID-19).
Proceedings of the National Academy of Sciences, 117(30), 17720-17726.
}
\details{
https://doi.org/10.1073/pnas.2008410117
}
\keyword{datasets}
