% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{J1League_tbl_df}
\alias{J1League_tbl_df}
\title{Japanese J1 League Results}
\format{
A tibble with 3,213 observations and 7 variables:
\describe{
  \item{Season}{Season year of the match (numeric)}
  \item{DateTime}{Date and time of the match (POSIXct)}
  \item{Home}{Home team name (character)}
  \item{Away}{Away team name (character)}
  \item{HG}{Number of goals scored by the home team (numeric)}
  \item{AG}{Number of goals scored by the away team (numeric)}
  \item{Res}{Final result of the match (character)}
}
}
\source{
Data obtained from Kaggle: \url{https://www.kaggle.com/datasets/irkaal/japanese-j1-league}
}
\usage{
data(J1League_tbl_df)
}
\description{
This dataset, J1League_tbl_df, is a tibble containing results of Japan's J1 League matches from 2012 to 2022.
The dataset includes information such as the season, match date and time, home and away teams, goals scored,
and final match result. The dataset preserves the original structure from its source on Kaggle.
}
\details{
The dataset name has been kept as 'J1League_tbl_df' to maintain consistency with the naming conventions
in the JapanAPIs package. The suffix 'tbl_df' indicates that this is a tibble data frame. The original content
has not been modified in any way.
}
