% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Langevin2D.r
\name{Langevin2D}
\alias{Langevin2D}
\title{Calculate the Drift and Diffusion of two-dimensional stochastic processes}
\usage{
Langevin2D(
  data,
  bins,
  steps,
  sf = ifelse(is.mts(data), frequency(data), 1),
  bin_min = 100,
  reqThreads = -1
)
}
\arguments{
\item{data}{a matrix containing the time series as columns or a time-series
object.}

\item{bins}{a scalar denoting the number of \code{bins} to calculate Drift
and Diffusion on.}

\item{steps}{a vector giving the \eqn{\tau} steps to calculate the moments
(in samples).}

\item{sf}{a scalar denoting the sampling frequency (optional if \code{data}
is a time-series object).}

\item{bin_min}{a scalar denoting the minimal number of events per \code{bin}.
Defaults to \code{100}.}

\item{reqThreads}{a scalar denoting how many threads to use. Defaults to
\code{-1} which means all available cores.}
}
\value{
\code{Langevin2D} returns a list with nine components:

\item{D1}{a tensor with all values of the drift coefficient.
Dimension is \code{bins} x \code{bins} x 2. The first
\code{bins} x \code{bins} elements define the drift \eqn{D^{(1)}_{1}}
for the first variable and the rest define the drift \eqn{D^{(1)}_{2}}
for the second variable.}

\item{eD1}{a tensor with all estimated errors of the drift
coefficient. Dimension is \code{bins} x \code{bins} x 2. Same expression as
above.}

\item{D2}{a tensor with all values of the diffusion coefficient.
Dimension is \code{bins} x \code{bins} x 3. The first
\code{bins} x \code{bins} elements define the diffusion \eqn{D^{(2)}_{11}},
the second \code{bins} x \code{bins} elements define the diffusion
\eqn{D^{(2)}_{22}} and the rest define the diffusion
\eqn{D^{(2)}_{12} = D^{(2)}_{21}}.}

\item{mean_bin}{a matrix of the mean value per \code{bin}.
Dimension is \code{bins} x \code{bins} x 2. The first
\code{bins} x \code{bins} elements define the mean for the first variable
and the rest for the second variable.}

\item{density}{a matrix of the number of events per \code{bin}.
Rows label the \code{bin} of the first variable and columns the second
variable.}

\item{M1}{a tensor of the first moment for each \code{bin} (line
label) and  each \eqn{\tau} step (column label). Dimension is
\code{bins} x \code{bins} x 2\code{length(steps)}.}

\item{eM1}{a tensor of the standard deviation of the first
moment for each bin (line label) and  each \eqn{\tau} step (column label).
Dimension is \code{bins} x \code{bins} x 2\code{length(steps)}.}

\item{M2}{a tensor of the second moment for each bin (line
label) and  each \eqn{\tau} step (column label). Dimension is
\code{bins} x \code{bins} x 3\code{length(steps)}.}

\item{U}{a matrix of the \code{bin} borders}
}
\description{
\code{Langevin2D} calculates the Drift (with error) and Diffusion matrices
for given time series.
}
\seealso{
\code{\link{Langevin1D}}
}
\author{
Philip Rinn
}
