#' @title Run the LifeTableFertility 'shiny' application (internal helper)
#' @description Internal helper that launches the bundled 'shiny' app.
#' @param ... Passed to shiny::runApp().
#' @param app_dir Internal/testing override for app directory. Default uses system.file().
#' @keywords internal
run_app <- function(..., app_dir = NULL) {
  if (is.null(app_dir)) {
    app_dir <- system.file("app", package = "LifeTableFertility")
  }
  
  if (app_dir == "" || !dir.exists(app_dir)) {
    stop(
      "Cannot find the 'shiny' app directory. ",
      "Please reinstall the package or check that 'inst/app' is included.",
      call. = FALSE
    )
  }
  
  shiny::runApp(appDir = app_dir, ...)
}

#' @title LifeTableFertility
#' @description Launch the LifeTableFertility 'shiny' application for life table and fertility analysis.
#' @return Runs a 'shiny' app (interactive).
#' @export
#' @examples
#' if (interactive()) {
#'   LifeTableFertility()
#' }
LifeTableFertility <- function() {
  run_app(display.mode = "normal")
}
