% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Luminescence-package.R
\name{BaseDataSet}
\alias{BaseDataSet}
\alias{BaseDataSet.ConversionFactors}
\alias{BaseDataSet.GrainSizeAttenuation}
\alias{BaseDataSet.FractionalGammaDose}
\title{Base datasets}
\format{
\strong{Dose-rate conversion factors}

A \code{\link{list}} with three elements with dose-rate conversion factors
sorted by article and radiation type (alpha, beta, gamma):

\tabular{ll}{

\code{AdamiecAitken1998}: \tab
Conversion factors from Tables 5 and 6 \cr

\code{Cresswelletal2018}: \tab
Conversion factors from Tables 5 and 6 \cr

\code{Guerinetal2011}: \tab
Conversion factors from Tables 1, 2 and 3 \cr

\code{Liritzisetal2013}: \tab
Conversion factors from Tables 1, 2 and 3 \cr
}

\strong{Grain size attenuation data}

A \code{\link{data.frame}} seven columns and sixteen rows. Column headers
are \code{GrainSize}, \code{Q_K}, \code{FS_K}, \code{Q_Th}, \code{FS_Th}, \code{Q_U}, \code{FS_U}.
Grain sizes are quoted in µm (e.g., 20, 40, 60 etc.)

\strong{Fractional gamma dose-rate values}

A \code{\link{list}} with fractional gamma dose-rate values sorted by article:

\tabular{ll}{

\code{Aitken1985}: \tab
Fractional gamma-dose values from table H.1
}
}
\source{
\strong{Dose-rate conversion factors}

All gamma conversion factors were carefully read from the tables given in:

Adamiec, G., Aitken, M.J., 1998. Dose-rate conversion factors: update.
Ancient TL 16, 37-46.

Cresswell., A.J., Carter, J., Sanderson, D.C.W., 2018.
Dose rate conversion parameters: Assessment of nuclear data.
Radiation Measurements 120, 195-201.

Guérin, G., Mercier, N., Adamiec, G., 2011. Dose-rate conversion
factors: update. Ancient TL, 29, 5-8.

Liritzis, I., Stamoulis, K., Papachristodoulou, C., Ioannides, K., 2013.
A re-evaluation of radiation dose-rate conversion factors. Mediterranean
Archaeology and Archaeometry 13, 1-15.

\strong{Grain size attenuation data}

Guérin, G., Mercier, N., Nathan, R., Adamiec, G., Lefrais, Y., 2012.
On the use of the infinite matrix assumption and associated concepts:
A critical review. Radiation Measurements, 47, 778-785.

\strong{Fractional gamma dose-rate values}

Fractional gamma dose values were carefully read from the tables given in:

Aitken, M.J., 1985. Thermoluminescence Dating. Academic Press, London.
}
\description{
Collection of datasets with published and unpublished data used within the
package.

\describe{
\item{BaseData.ConversionFactors}{Collection of published dose-rate
conversion factors to convert concentrations of radioactive isotopes to
dose rate values}
\item{BaseData.GrainSizeAttenuation}{Grain size attenuation data by Guérin
et al. (2012)}
\item{BaseData.FractionalGammaDose}{Collection of (un-)published fractional
gamma dose-rate values to scale the gamma-dose rate considering layer-to-layer
variations in soil radioactivity}
}
}
\section{Version}{
 0.2.0
}

\examples{
## conversion factors
data("BaseDataSet.ConversionFactors", envir = environment())

## grain size attenuation
data("BaseDataSet.GrainSizeAttenuation", envir = environment())

## fractional gamma dose
data("BaseDataSet.FractionalGammaDose", envir = environment())

}
\keyword{datasets}
