% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Luminescence-generics.R,
%   R/RLum.Analysis-class.R, R/RLum.Data.Curve-class.R,
%   R/RLum.Data.Image-class.R, R/RLum.Data.Spectrum-class.R,
%   R/RLum.Results-class.R
\name{get_RLum}
\alias{get_RLum}
\alias{get_RLum,list-method}
\alias{get_RLum,NULL-method}
\alias{get_RLum,RLum.Analysis-method}
\alias{get_RLum,RLum.Data.Curve-method}
\alias{get_RLum,RLum.Data.Image-method}
\alias{get_RLum,RLum.Data.Spectrum-method}
\alias{get_RLum,RLum.Results-method}
\title{General accessor function for RLum-class objects}
\usage{
get_RLum(object, ...)

\S4method{get_RLum}{list}(object, class = NULL, null.rm = FALSE, ...)

\S4method{get_RLum}{NULL}(object, ...)

\S4method{get_RLum}{RLum.Analysis}(
  object,
  record.id = NULL,
  recordType = NULL,
  curveType = NULL,
  RLum.type = NULL,
  protocol = "UNKNOWN",
  get.index = FALSE,
  drop = TRUE,
  recursive = TRUE,
  info.object = NULL,
  subset = NULL,
  env = parent.frame(2)
)

\S4method{get_RLum}{RLum.Data.Curve}(object, info.object = NULL)

\S4method{get_RLum}{RLum.Data.Image}(object, info.object = NULL)

\S4method{get_RLum}{RLum.Data.Spectrum}(object, info.object = NULL)

\S4method{get_RLum}{RLum.Results}(object, data.object, info.object = NULL, drop = TRUE)
}
\arguments{
\item{object}{\linkS4class{RLum} (\strong{required}):
S4 object of class \code{RLum} or an object of type \link{list} containing only objects
of type \linkS4class{RLum}}

\item{...}{further arguments passed to the specific class method.}

\item{class}{\link{character} (\emph{optional}):
define which class gets selected if applied to a list, e.g., if a list
consists of different type of \linkS4class{RLum} objects, this arguments allows
to make a selection. If nothing is provided, all \linkS4class{RLum} objects are
treated.}

\item{null.rm}{\link{logical} (\emph{with default}):
whether empty and \code{NULL} objects should be removed.}

\item{record.id}{\link{numeric} or \link{logical} (\emph{optional}):
IDs of specific records. If of type \code{logical} the entire id range is assumed
and \code{TRUE} and \code{FALSE} indicates the selection.}

\item{recordType}{\link{character} (\emph{optional}):
record type (e.g., "OSL"). Can be also a vector, for multiple matching,
e.g., \code{recordType = c("OSL", "IRSL")}}

\item{curveType}{\link{character} (\emph{optional}):
curve type (e.g. "predefined" or "measured")}

\item{RLum.type}{\link{character} (\emph{optional}):
RLum object type. Defaults to "RLum.Data.Curve" and "RLum.Data.Spectrum".}

\item{protocol}{\link{character} (\emph{optional}):
currently ignored.}

\item{get.index}{\link{logical} (\emph{optional}):
return a numeric vector with the index of each element in the RLum.Analysis
object (\code{FALSE} by default).}

\item{drop}{\link{logical} (\emph{with default}):
coerce to the next possible layer (which are \linkS4class{RLum.Data} objects if
\code{object} is an \linkS4class{RLum.Analysis} object). If \code{drop = FALSE}, an object
of the same type as the input is returned.}

\item{recursive}{\link{logical} (\emph{with default}):
if \code{TRUE} (default) when the result of the \code{get_RLum()} request is a single
object, the object itself will be returned directly, rather than being
wrapped in a list. Mostly this makes things easier, but this might be
undesired if this method is used within a loop.}

\item{info.object}{\link{character} (\emph{optional}):
name of the wanted info element.}

\item{subset}{\link{expression} (\emph{optional}):
logical or character masking a logical expression indicating elements or rows to keep:
missing values are taken as false. This argument takes precedence over all other arguments,
meaning they are not considered when subsetting the object. \code{subset} works slots and
info elements.}

\item{env}{\link{environment} (\emph{with default}):
An environment passed to \link{eval} as the enclosure. This argument is only
relevant when subsetting the object and should not be used manually.}

\item{data.object}{\link{character} or \link{numeric}:
name or index of the data slot to be returned.}
}
\value{
An object of the same type as the input object provided.
}
\description{
The function provides a generalised access point for specific
\linkS4class{RLum} objects. Depending on the input object, the corresponding
function will be selected.
}
\section{Functions}{
\itemize{
\item \code{get_RLum(list)}: Returns a list of \linkS4class{RLum} objects that had been passed to \link{get_RLum}

\item \code{get_RLum(`NULL`)}: Returns \code{NULL}.

\item \code{get_RLum(RLum.Analysis)}: Accessor method for RLum.Analysis objects.
The optional arguments \code{record.id}, \code{recordType}, \code{curveType} and \code{RLum.type}
allow to limit records by their id (list index number), their record type
(e.g. \code{recordType = "OSL"}), their curve type (e.g. \code{curveType = "predefined"}
or \code{curveType ="measured"}), or object type.

The selection of a specific RLum.type object superimposes the default selection.
Currently supported objects are: RLum.Data.Curve and RLum.Data.Spectrum

Returns:
\enumerate{
\item \link{list} of \linkS4class{RLum.Data} objects or
\item Single \linkS4class{RLum.Data} object, if only one object is contained and \code{recursive = FALSE} or
\item \linkS4class{RLum.Analysis} objects for \code{drop = FALSE}
}

\item \code{get_RLum(RLum.Data.Curve)}: Accessor method for \linkS4class{RLum.Data.Curve} object.
The argument \code{info.object} is optional to directly access the info elements.
If no info element name is provided, the raw curve data (matrix) will be
returned.

\item \code{get_RLum(RLum.Data.Image)}: Accessor method for \linkS4class{RLum.Data.Image} objects.
The argument \code{info.object} is optional to directly access the info elements.
If no info element name is provided, the raw image data (\code{array}) will be
returned.

\item \code{get_RLum(RLum.Data.Spectrum)}: Accessor method for \linkS4class{RLum.Data.Spectrum} objects.
The argument \code{info.object} is optional to directly access the info elements.
If no info element name is provided, the raw curve data (matrix) will be
returned.

\item \code{get_RLum(RLum.Results)}: Accessor method for \linkS4class{RLum.Results} object.
The argument \code{data.object} allows to access directly objects stored
within the slot data. The default return object depends on the object
originator (e.g., \code{fit_LMCurve}). If nothing is specified always the first
\code{data.object} will be returned.

Note: Detailed specification should be made in combination with the
originator slot in the receiving function if results are piped.

Returns:
\enumerate{
\item Data object from the specified slot
\item \link{list} of data objects from the slots if 'data.object' is vector or
\item an \linkS4class{RLum.Results} for \code{drop = FALSE}.
}

}}
\section{Function version}{
 0.3.3
}

\examples{

## Example based using data and from the calc_CentralDose() function

## load example data
data(ExampleData.DeValues, envir = environment())

## apply the central dose model 1st time
temp1 <- calc_CentralDose(ExampleData.DeValues$CA1)

## get results and store them in a new object
temp.get <- get_RLum(object = temp1)

}
\seealso{
\linkS4class{RLum.Data.Curve}, \linkS4class{RLum.Data.Image},
\linkS4class{RLum.Data.Spectrum}, \linkS4class{RLum.Analysis}, \linkS4class{RLum.Results}
}
\author{
Sebastian Kreutzer, Institute of Geography, Heidelberg University (Germany)
, RLum Developer Team} 

\section{How to cite}{
Kreutzer, S., 2025. get_RLum(): General accessor function for RLum-class objects. Function version 0.3.3. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., Colombo, M., Steinbuch, L., Boer, A.d., 2025. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 1.1.2. https://r-lum.github.io/Luminescence/
}

\keyword{utilities}
