% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popmad.R
\name{pop.mad}
\alias{pop.mad}
\title{Population Median Absolute Deviation (MAD)}
\usage{
pop.mad(qf, pf, upper, constant = 1.4826, ...)
}
\arguments{
\item{qf}{the quantile function for the distribution.}

\item{pf}{the distribution function for the distribution.}

\item{upper}{an optional number specifying an upper limit for the MAD.  This can be missing although the user may want to specify an upper limit if there are computation issues.}

\item{constant}{a scale factor. Default choice ensures population MAD is equal to SD for the normal distribution.}

\item{...}{additional parameter values for the distribution, otherwise default choices are used for the specific quantile and distribution functions.}
}
\value{
A value representing the MAD for the distribution.
}
\description{
This function calculates the population Median Absolute Deviation (MAD) for a user-specified distribution.
}
\details{
This function calculates the Median Absolute Deviation (MAD) for a distribution specified by the user. The user is required to input the quantile and
distribution functions, as well as any parameters required for the nominated distribution.  If the function is unable to find
the MAD using function \code{root}, the user may specify another upper limit for the MAD to help with computation.  If \code{upper} is missing, \code{upper}
is chosen to be the maximum of the third quartile minus the median and the median minus the first quantile (the MAD cannot be greater than this upper limit).  For more information in the MAD see, e.g., Hampel et al. (1986).
}
\examples{
# Population MAD for the normal distribution
pop.mad(qnorm, pnorm, sd = 1.5)

# Note that due to the scaling constant used, the mad is equal to the SD for the normal distribution
}
\references{
Hampel, F. R., Ronchetti, E. M., Rousseeuw, P. J. & Stahel, W. A. (1986). Robust statistics: The approach based on influence functions. New York, NY: John Wiley & Sons.
}
