% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d_dep_t_avg.R
\name{d_dep_t_avg}
\alias{d_dep_t_avg}
\alias{d.dep.t.avg}
\title{Cohen's d for Paired t Using the Average SD Denominator}
\usage{
d_dep_t_avg(m1, m2, sd1, sd2, n, a = 0.05)

d.dep.t.avg(m1, m2, sd1, sd2, n, a = 0.05)
}
\arguments{
\item{m1}{Mean from the first level/occasion.}

\item{m2}{Mean from the second level/occasion.}

\item{sd1}{Standard deviation from the first level/occasion.}

\item{sd2}{Standard deviation from the second level/occasion.}

\item{n}{Sample size (number of paired observations).}

\item{a}{Significance level (alpha) for the confidence interval.
Must be in (0, 1).}
}
\value{
A list with the following elements:
\describe{
  \item{d}{Cohen's \eqn{d_{av}}.}
  \item{dlow}{Lower limit of the \eqn{(1-\alpha)}
confidence interval for \eqn{d_{av}}.}
  \item{dhigh}{Upper limit of the \eqn{(1-\alpha)}
confidence interval for \eqn{d_{av}}.}
  \item{M1, M2}{Group means.}
  \item{M1low, M1high, M2low, M2high}{Confidence interval
bounds for each mean.}
  \item{sd1, sd2}{Standard deviations.}
  \item{se1, se2}{Standard errors of the means.}
  \item{n}{Sample size.}
  \item{df}{Degrees of freedom (\eqn{n - 1}).}
  \item{estimate}{APA-style formatted string for reporting
\eqn{d_{av}} and its CI.}
}
}
\description{
**Note on function names:**
This function now uses the snake_case name `d_dep_t_avg()` to follow
modern R style guidelines and CRAN recommendations.
The dotted version `d.dep.t.avg()` is still included as a wrapper
for backward compatibility, so older code will continue to work.
Both functions produce identical results, but new code should use
`d_dep_t_avg()`. The output function also provides backwards
compatibility and new snake case variable names.
}
\details{
Compute Cohen's \eqn{d_{av}} and a noncentral-t confidence interval for
repeated-measures (paired-samples) designs using the **average of the two
standard deviations** as the denominator.


The effect size is defined as the mean difference divided by the average SD:
\deqn{d_{av} = \frac{m_1 - m_2}{\left( s_1 + s_2 \right)/2}.}

The test statistic used for the noncentral-t confidence interval is based on
the average of the two standard errors, \eqn{se_i = s_i/\sqrt{n}}:
\deqn{t = \frac{m_1 - m_2}{\left( \frac{s_1}{\sqrt{n}} +
\frac{s_2}{\sqrt{n}} \right) / 2}.}

See the online example for additional context:
\href{https://www.aggieerin.com/shiny-server/tests/deptavgm.html}{Learn more on our example page.}
}
\examples{
# The following example is derived from the "dept_data" dataset included
# in the MOTE package.

# Suppose seven people completed a measure of belief in the supernatural
# before and after watching a sci-fi movie.
# Higher scores indicate stronger belief.

    t.test(dept_data$before, dept_data$after, paired = TRUE)

# You can type in the numbers directly, or refer to the
# dataset, as shown below.

    d_dep_t_avg(m1 = 5.57, m2 = 4.43, sd1 = 1.99,
                sd2 = 2.88, n = 7, a = .05)

    d_dep_t_avg(5.57, 4.43, 1.99, 2.88, 7, .05)

    d_dep_t_avg(mean(dept_data$before), mean(dept_data$after),
                sd(dept_data$before), sd(dept_data$after),
                length(dept_data$before), .05)
}
\keyword{cohen's}
\keyword{d}
\keyword{d_average}
\keyword{dependent}
\keyword{effect}
\keyword{measures}
\keyword{paired-sample}
\keyword{repeated}
\keyword{size}
\keyword{t-test}
