\name{Permutation_Function}
\alias{Permutation_Function}
\title{
Permutation-based hypothesis testing procedure for REMAXINT and E-REMI based test statistic(s). 
}
\description{
Conducts a permutation test to assess the significance of a latent interaction structure in a data matrix using two model-based clustering approaches: REMAXINT and E-ReMI. It compares the observed likelihood ratio statistics to the distribution under the null hypothesis derived from permutations.
}
\usage{
Permutation_Function(D, P, Q, Nruns, permutations, alpha_level)
}
\arguments{
  \item{D}{
  A numeric matrix of dimension \code{I x J}, representing the data to be analyzed.
  }
  \item{P}{
  An integer specifying the number of row clusters.
  }
  \item{Q}{
  An integer specifying the number of column clusters.
  }
  \item{Nruns}{
  The number of REMAXINT and E-REMI algorithms runs to perform for each clustering to avoid local optima.
  }
  \item{permutations}{
  The number of permutations used to compute the empirical null distribution.
  }
  \item{alpha_level}{
  The significance level (e.g., 0.05) used to determine critical values from the permutation distribution.
  }
}
\details{
This function applies a model-based biclustering algorithm (REMAXINT and E-ReMI) to the original and permuted data matrices to test the presence of an underlying block mean (interaction) structure. 
For each method, it computes the observed log-likelihood ratio (LLR) statistic and compares it to a distribution of LLRs under the null hypothesis generated through permutation. 
The procedure yields empirical \( p \)-values and critical values, allowing for hypothesis testing on whether the data contains a meaningful block structure or not.
}
\value{
A list containing the following components:
\item{Obs_Log_LR_REMAXINT}{Observed log-likelihood ratio statistic for the REMAXINT method.}
\item{Obs_Log_LR_EReMI}{Observed log-likelihood ratio statistic for the E-ReMI method.}
\item{Perm_Log_LR_REMAXINT}{Vector of log-likelihood ratio statistics from permutations for REMAXINT.}
\item{Perm_Log_LR_EReMI}{Vector of log-likelihood ratio statistics from permutations for E-ReMI.}
\item{Crit_Value_Perm_REMAXINT}{Critical value at the specified \code{alpha_level} from the REMAXINT permutation distribution.}
\item{Crit_Value_Perm_EReMI}{Critical value at the specified \code{alpha_level} from the E-ReMI permutation distribution.}
\item{P_value_Perm_REMAXINT}{Empirical \( p \)-value from permutation test for REMAXINT.}
\item{P_value_Perm_EReMI}{Empirical \( p \)-value from permutation test for E-ReMI.}
\item{Z_REMAXINT}{Maximal row cluster assignment matrix from REMAXINT on observed data.}
\item{K_REMAXINT}{Maximal column cluster assignment matrix from REMAXINT on observed data.}
\item{Z_EReMI}{Maximal row cluster assignment matrix from E-ReMI on observed data.}
\item{K_EReMI}{Maximal column cluster assignment matrix from E-ReMI on observed data.}
\item{Gamma_REMAXINT}{Estimated block mean (bi-cluster intercation) matrix from REMAXINT.}
\item{Gamma_EReMI}{Estimated block mean (bi-cluster intercation) matrix from E-ReMI.}
}
\references{
Ahmed, Z., van Breukelen, G. J. P., Schepers, J., & Cassese, A. (2025). Robustness study of normality-based likelihood ratio tests 
for testing maximal interaction two-mode clustering and a permutation based alternative. \emph{Available on OSF} 
(submitted to Advances in Data Analysis and Classification).
Ahmed, Z., van Breukelen, G. J. P., Schepers, J., & Cassese, A. (2023). E-ReMI: extended maximal interaction two-mode clustering. 
\emph{Journal of Classification, 40,  298-331}
Ahmed, Z., van Breukelen, G. J. P., Schepers, J., & Cassese, A. (2021). REMAXINT: a two-mode clustering-based method for statistical
inference on two-way interaction. \emph{Advances in Data Analysis and Classification, 15(4), 987-1013}
}
\author{
Zaheer Ahmed (ahmed@ifado.de), 
Jan Schepers (jan.schepers@maastrichtuniversity.nl), 
Uwe Ligges (ligges@statistik.tu-dortmund.de), 
Alberto Cassese (alberto.cassese@unifi.it), 
Gerard van Breukelen (gerard.vbreukelen@maastrichtuniversity.nl), 
Katja Ickstadt (ickstadt@statistik.tu-dortmund.de), 
Edmund Wascher (wascher@ifado.de)
}
\note{
Permutation function ensures input matrix \code{D} is preprocessed appropriately (e.g., doubly centered) within this function.
}
\seealso{
\code{\link{REMAXINT}}, \code{\link{E_ReMI}}, \code{\link{Log_LR_Test_Statistic}}
}
\examples{
I <- 10; P <- 4; J <- 5; Q <- 2; Nruns <- 5; permutations <- 10; alpha_level <- 0.05
D <- matrix(rnorm(I*J), I, J)
result <- Permutation_Function(D, P, Q, Nruns, permutations, alpha_level)
result
}
