\name{REMAXINT}
\alias{REMAXINT}
\title{
Two-Mode Clustering via the REMAXINT Method
}
\description{
Performs two-mode clustering (row and column) of a data matrix using the REMAXINT (Random Effect Maximal Interaction Two-mode Clustering) algorithm. 
It iteratively updates row and column cluster memberships to maximize a Gaussian log-likelihood criterion and ultimately provides partitions of the 
data that maximize interaction between row and column clusters. Furthermore, REMAXINT method assumes row and column clusters sizes are equal in expectation. 
}
\usage{
REMAXINT(DC, P, Q, Nruns)
}
\arguments{
  \item{DC}{
  A doubly centered numeric matrix of dimension \code{I x J} representing the data to be clustered.
}
  \item{P}{
  An integer indicating the number of row clusters.
}
  \item{Q}{
  An integer indicating the number of column clusters.
}
  \item{Nruns}{
  An integer specifying the number of random initializations (runs) to perform. The best solution (based on log-likelihood) is returned.
}
}
\details{
The REMAXINT function implements a likelihood-based biclustering approach. For each of the specified \code{Nruns}, it initializes row and column cluster assignments randomly and iteratively updates them to maximize the log-likelihood of the data under a block interaction model. The algorithm uses alternating updates of the row and column cluster assignments, along with an estimation of the latent cluster interaction matrix \code{G} and noise variance. To avoid poor local maxima, multiple random starts are performed, and the result with the highest final log-likelihood is selected.
}
\value{
A list with the following components:
  \item{BestR}{An \code{I x P} binary matrix indicating maximal row cluster assignments.}
  \item{BestC}{A \code{J x Q} binary matrix indicating maximal column cluster assignments.}
  \item{BestG}{A \code{P x Q} matrix representing estimated latent interactions between row and column clusters.}
  \item{LL}{The maximized log-likelihood value corresponding to the maximal clustering solution.}
}
\references{
Ahmed, Z., van Breukelen, G. J. P., Schepers, J., & Cassese, A. (2025). Robustness study of normality-based likelihood ratio tests 
for testing maximal interaction two-mode clustering and a permutation based alternative. \emph{Available on OSF} 
(submitted to Advances in Data Analysis and Classification).
Ahmed, Z., van Breukelen, G. J. P., Schepers, J., & Cassese, A. (2023). E-ReMI: extended maximal interaction two-mode clustering. 
\emph{Journal of Classification, 40,  298-331}
Ahmed, Z., van Breukelen, G. J. P., Schepers, J., & Cassese, A. (2021). REMAXINT: a two-mode clustering-based method for statistical
inference on two-way interaction. \emph{Advances in Data Analysis and Classification, 15(4), 987-1013}
}
\author{
Zaheer Ahmed (ahmed@ifado.de), 
Jan Schepers (jan.schepers@maastrichtuniversity.nl),
Uwe Ligges (ligges@statistik.tu-dortmund.de), 
Alberto Cassese (alberto.cassese@unifi.it), 
Gerard van Breukelen (gerard.vbreukelen@maastrichtuniversity.nl), 
Katja Ickstadt (ickstadt@statistik.tu-dortmund.de), 
Edmund Wascher (wascher@ifado.de)
}
\note{
This method is particularly useful when the data shows block-wise latent interaction structures between row and column clusters.
}
\seealso{
\code{\link{Permutation_Function}}, \code{\link{Randompartition_function}}, \code{\link{Update_row_clusters_REMAXINT}}, 
\code{\link{Update_column_clusters}}, \code{\link{Update_G_Omega}}, \code{\link{Log_Likelihood_function_REMAXINT}},
}
\examples{
I <- 10; P <- 4; J <- 5; Q <- 2; Nruns <- 5
DC <- matrix(rnorm(I*J), I, J)
result <- REMAXINT(DC, P, Q, Nruns)
result
}
\keyword{REMAXINT}
\keyword{Two-mode data}
\keyword{Maximal interaction}
