\name{Unequal_Randompartition_Function}
\alias{Unequal_Randompartition_Function}
\title{
Generate a Random Partition Matrix of Unequally sized row clusters. Therefore, it assign higher weight or probability to first the row cluster and the remaining row clusters are evenly distributed. 
}
\description{
Generates a binary matrix representing a random partition of \code{i} rows into \code{p} row groups, ensuring each group is represented at least once, and allowing the first group to have a higher probability.
}
\usage{
Unequal_Randompartition_Function(i, p, firstp)
}
\arguments{
  \item{i}{
An integer specifying the total number of items (rows) to partition.
}
  \item{p}{
An integer specifying the number of clusters or groups.
}
  \item{firstp}{
A numeric value (between 0 and 1) indicating the selection probability for the first group. The remaining probability is evenly distributed among the remaining \code{p-1} groups.
}
}
\details{
The function first initializes a \code{p x p} identity matrix to ensure each group is selected at least once. The rest of the rows (\code{i - p}) are assigned to groups based on a multinomial distribution with a specified probability vector, where the first group's probability is \code{firstp} and the rest share the remaining \code{1 - firstp} equally.
}
\value{
A binary matrix of dimension \code{i x p}, where each row contains a single 1 indicating the assigned group, and 0s elsewhere.
}
\references{
Ahmed, Z., van Breukelen, G. J. P., Schepers, J., & Cassese, A. (2025). Robustness study of normality-based likelihood ratio tests 
for testing maximal interaction two-mode clustering and a permutation based alternative. \emph{Available on OSF} 
(submitted to Advances in Data Analysis and Classification).
Ahmed, Z., van Breukelen, G. J. P., Schepers, J., & Cassese, A. (2023). E-ReMI: extended maximal interaction two-mode clustering. 
\emph{Journal of Classification, 40,  298-331}
Ahmed, Z., van Breukelen, G. J. P., Schepers, J., & Cassese, A. (2021). REMAXINT: a two-mode clustering-based method for statistical
inference on two-way interaction. \emph{Advances in Data Analysis and Classification, 15(4), 987-1013}
}
\author{
Zaheer Ahmed (ahmed@ifado.de), 
Jan Schepers (jan.schepers@maastrichtuniversity.nl), 
Uwe Ligges (ligges@statistik.tu-dortmund.de), 
Alberto Cassese (alberto.cassese@unifi.it), 
Gerard van Breukelen (gerard.vbreukelen@maastrichtuniversity.nl), 
Katja Ickstadt (ickstadt@statistik.tu-dortmund.de), 
Edmund Wascher (wascher@ifado.de)
}
\note{
This function is primarily used for generating initial row cluster membership matrix in the E-ReMI methods.
}
\seealso{
\code{\link{E_ReMI}, \link{rmultinom}, \link{diag}, \link{sample}}
}
\examples{
result <- Unequal_Randompartition_Function(i = 20, p = 4, firstp = 0.5)
result
}
\keyword{random row partition matrix in E_ReMI}
