% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{accu_samp_threshold}
\alias{accu_samp_threshold}
\title{Compute the number of sequence to obtain a given proportion of ASV in
accumulation curves}
\usage{
accu_samp_threshold(res_accuplot, threshold = 0.95)
}
\arguments{
\item{res_accuplot}{the result of the function accu_plot()}

\item{threshold}{the proportion of ASV to obtain in each samples}
}
\value{
a value for each sample of the number of sequences needed
to obtain \code{threshold} proportion of the ASV
}
\description{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-experimental-orange" alt="lifecycle-experimental"></a>
}}


Note that as most bioinformatic pipeline discard singleton, accumulation curves from metabarcoding
cannot be interpreted in the same way as with conventional biodiversity sampling techniques.
}
\examples{
\donttest{
data("GlobalPatterns", package = "phyloseq")
GP <- subset_taxa(GlobalPatterns, GlobalPatterns@tax_table[, 1] == "Archaea")
GP <- rarefy_even_depth(subset_samples_pq(GP, sample_sums(GP) > 3000))
p <- accu_plot(GP, "SampleType", add_nb_seq = TRUE, by.fact = TRUE, step = 10)

val_threshold <- accu_samp_threshold(p)

summary(val_threshold)

##'  Plot the number of sequences needed to accumulate 0.95\% of ASV in 50\%, 75\%
##'  and 100\% of samples
p + geom_vline(xintercept = quantile(val_threshold, probs = c(0.50, 0.75, 1)))
}
}
\seealso{
\code{\link[=accu_plot]{accu_plot()}}
}
\author{
Adrien Taudière
}
