% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{accu_plot_balanced_modality}
\alias{accu_plot_balanced_modality}
\title{Plot accumulation curves with balanced modality and depth rarefaction}
\usage{
accu_plot_balanced_modality(
  physeq,
  fact,
  nperm = 99,
  step = 2000,
  by.fact = TRUE,
  progress_bar = TRUE,
  quantile_prob = 0.975,
  rarefy_by_sample_before_merging = TRUE,
  sample.size = 1000,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{physeq}{(required) a \code{\link[phyloseq]{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{fact}{(required) The variable to rarefy. Must be present in
the \code{sam_data} slot of the physeq object.}

\item{nperm}{(int) The number of permutations to perform.}

\item{step}{(int) distance among points calculated to plot lines.
A low value give better plot but is more time consuming.}

\item{by.fact}{(logical, default TRUE)
First merge the OTU table by factor to plot only one line by factor}

\item{progress_bar}{(logical, default TRUE) Do we print progress during
the calculation?}

\item{quantile_prob}{(float, \verb{[0:1]}) the value to compute the quantile.
Minimum quantile is compute using 1-quantile_prob.}

\item{rarefy_by_sample_before_merging}{(logical, default TRUE):
rarefy_by_sample_before_merging = FALSE is buggy for the moment.Please
only use rarefy_by_sample_before_merging = TRUE}

\item{sample.size}{(int) A single integer value equal to the number of
reads being simulated, also known as the depth. See
\code{\link[phyloseq:rarefy_even_depth]{phyloseq::rarefy_even_depth()}}.}

\item{verbose}{(logical). If TRUE, print additional information.}

\item{...}{Other params for be passed on to \code{\link[=accu_plot]{accu_plot()}} function}
}
\value{
A ggplot2 plot representing the richness accumulation plot
}
\description{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-experimental-orange" alt="lifecycle-experimental"></a>
}}


This function (i) rarefy (equalize) the number of samples per modality of a
factor and (ii) rarefy the number of sequences per sample (depth). The
seed is set to 1:nperm. Thus, with exacly the same parameter, including
nperm values, results must be identical.
}
\examples{
\donttest{
data_fungi_woNA4Time <-
  subset_samples(data_fungi, !is.na(Time))
data_fungi_woNA4Time@sam_data$Time <- paste0("time-", data_fungi_woNA4Time@sam_data$Time)
accu_plot_balanced_modality(data_fungi_woNA4Time, "Time", nperm = 3)

data_fungi_woNA4Height <-
  subset_samples(data_fungi, !is.na(Height))
accu_plot_balanced_modality(data_fungi_woNA4Height, "Height", nperm = 3)
}
}
\seealso{
\code{\link[=accu_plot]{accu_plot()}}, \code{\link[=rarefy_sample_count_by_modality]{rarefy_sample_count_by_modality()}}, \code{\link[phyloseq:rarefy_even_depth]{phyloseq::rarefy_even_depth()}}
}
\author{
Adrien Taudière
}
