
<!-- README.md is generated from README.Rmd. Please edit that file -->

# MixFrac

<!-- badges: start -->

<!-- badges: end -->

MixFrac is an R package for constructing mixed-level and regular
fractional factorial designs, with:

Automatic detection of regular designs of the form s^(k-p) Efficient
mixed-level construction using a combined J2 and H^ objective NONBPA
skeletons for non-multiple level structures Alias structures and
confounding summary (Ríos-Lira et al.) Deterministic trend-free run
orders (Coster 1993)

It is designed for practitioners needing flexible fractional factorial
designs in industrial experimentation, quality engineering, and
statistical design of experiments (DoE).

## Installation

You can install the development version of MixFrac like so:

``` r
devtools::install("MixFrac")
```

## Example

This is a basic example which shows you how to solve a common problem:
Example Usage 1. Mixed-level fractional factorial design (2 × 3 × 4), 12
runs Writing

library(MixFrac)

res \<- generate_ff( c(2,3,4), \# levels per factor n_runs = 12, \#
required runs tf = TRUE, \# compute trend-free order parts = c(1,2,3),
verbose = TRUE )

This produces:

Part 1: The fractional factorial design

Part 2: Metrics (H^, J2), GBM, alias chains & confounding

Part 3: Trend-free run order

2.  Regular 2-level fraction example (2^3 with 4 runs) Writing

res_reg \<- generate_ff( c(2,2,2), 4, tf = TRUE, parts = c(1,2,3),
verbose = TRUE )

The package automatically detects this as a candidate for a regular
2^(3-1) design and searches for the best generator set.

3.  Only print the design (Part 1) Writing

generate_ff( c(2,3,4), 12, tf = FALSE, parts = 1, verbose = TRUE )

4.  Only print alias structure + metrics (Parts 1 & 2) Writing

generate_ff( c(2,3,4), 12, tf = FALSE, parts = c(1,2), verbose = TRUE )

5.  Only trend-free ordering (Part 3) Writing

generate_ff( c(2,3,4), 12, tf = TRUE, parts = 3, verbose = TRUE )

What is special about using `README.Rmd` instead of just `README.md`?
You can include R chunks like so: Using README.Rmd allows inclusion of
executable R code, examples, and automatic generation of README.md.

Render the README with:

devtools::build_readme()

Commit:

README.md

Figures in man/figures/

for GitHub and CRAN visibility.

References

Guo, Y., Simpson, J. R., & Pignatiello, J. J. (2007). Construction of
Efficient Mixed-Level Fractional Factorial Designs. Journal of Quality
Technology, 39(3), 241–257.
<https://doi.org/10.1080/00224065.2007.11917691>

Pantoja-Pacheco et al. (2021). One Note for Fractionation and Increase
for Mixed-Level Designs When Levels Are Not Multiple. Mathematics,
9(13), 1455. <https://doi.org/10.3390/math9131455>

Ríos-Lira et al. (2021). Alias Structures and Sequential Experimentation
for Mixed-Level Designs. Mathematics, 9(23), 3053.
<https://doi.org/10.3390/math9233053>

Coster, D. C. (1993). Trend-Free Run Orders of Mixed-Level Fractional
Factorial Designs. Annals of Statistics, 21(4), 2072–2086.
<https://doi.org/10.1214/aos/1176349410>
