% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post_w.R
\name{post_w}
\alias{post_w}
\title{Posterior mixture weight calculation}
\usage{
post_w(
  w,
  a,
  b,
  s_EC2,
  s_EC1,
  s_C2C1,
  y_EC2,
  y_EC1 = -0.5,
  y_C2C1 = -0.5,
  tau0 = 1000,
  mu0 = 0,
  eps = 1e-12
)
}
\arguments{
\item{w}{Scalar. If \code{w > 1}, use the ADAPTIVE branch (logistic prior on log-Z).
If \verb{0 < w < 1}, use a fixed prior weight equal to \code{w}.}

\item{a, b}{Parameters used in the elastic function for dynamic mixing weight. Must satisfy \code{a < 0} and  \code{b > 0}.}

\item{s_EC2, s_EC1, s_C2C1}{Sampling variances for direct evidence (E vs. C2 trial), and edges of indirect evidence (E vs. C1 trial and C2 vs. C1 trial).}

\item{y_EC2, y_EC1, y_C2C1}{Estimated log-HR for E vs. C2 tria, E vs. C1 trial, C2 vs. C1 trial, respectively}

\item{mu0, tau0}{Mean and variance for the vague component.}

\item{eps}{Numeric scalar used for small-value clipping (default \code{1e-12}).}
}
\value{
A numeric vector of posterior weights in \verb{(0,1)} reflecting realized borrowing fraction of the informative component.
}
\description{
Computes posterior updated mixture weights for a two-component normal–normal model
using the standard logit-additive update. The \emph{prior} mixing weight is either a
fixed weight \eqn{w \in (0,1)} or a dynamic mixing weight as for eNAP prior:
\eqn{Z = n_{eff}^{-1/4}|y_{\mathrm{dir}} - y_{\mathrm{ind}}| / s_{\mathrm{link}}}:
where, \eqn{n_{eff}= s_{\mathrm{link}}^{-1}}

\eqn{w_(Z) = 1/exp(a + b \log (Z+1)), \quad a<0, \; b > 0.}
}
\details{
\itemize{
\item \strong{Fixed prior mixing weight (Robust NMAP Prior):} requires \verb{0 < w < 1}.
\item \strong{Adaptive branch (Adaptive NMAP Prior):} triggered by \code{w > 1}, requires \code{a<0} and \code{b > 0}.
This corresponds to a decreasing prior weight as the inconsistency grows.
\item All variance/SD arguments may be given as scalars or vectors; scalars are recycled.
}
}
\examples{
y_EC2  <- -0.5; y_EC1  <- -0.8; y_C2C1 <- -0.3
s_EC2 <- 0.2; s_EC1 <- 0.18; s_C2C1 <- 0.18

# Fixed mixing weight 0.5
post_w(w = 0.5, a = NA, b = NA,s_EC2,s_EC1,s_C2C1,
       y_EC2,y_EC1,y_C2C1)

# Dynamic weight with elastic function of (a=-4.6, b=3):
post_w(w = 2, a = -2.5, b = 10,s_EC2,s_EC1,s_C2C1,
       y_EC2,y_EC1,y_C2C1)

}
