#' Calculate NUE Balance
#' @description
#' The fraction of N inputs that are removed from the system.
#' Formula: NUEbal = No / Ni
#' @param No Sum total of N outputs.
#' @param Ni Sum total of N inputs.
#' @return A numeric vector of NUEbal values.
#' @examples
#' No <- c(50, 60)
#' Ni <- c(100, 110)
#' NUEbal(No, Ni)
#' @export
NUEbal <- function(No, Ni) {
  if (any(Ni == 0)) stop("Input N (Ni) cannot be zero.")
  return(No / Ni)
}