#' Calculate NUE Crop
#' @description
#' The fraction of fertilizer N that is utilized and allocated to yield N.
#' Formula: NUEcrop = YieldN / FertN
#' @param YieldN A numeric vector of the N removed as yield.
#' @param FertN A numeric value or vector for fertilizer N input.
#' @return A numeric vector of NUEcrop values.
#' @examples
#' YieldN <- c(80, 90, 100)
#' FertN <- 50
#' NUEcrop(YieldN, FertN)
#' @export
NUEcrop <- function(YieldN, FertN) {
  if (any(FertN == 0)) stop("FertN cannot be zero.")
  return(YieldN / FertN)
}