#' Calculate NUE Soil
#' @description
#' The biomass production per unit of available N.
#' Formula: NUEsoil = PlantBM / (FertN + SoilN)
#' @param PlantBM A numeric vector of plant biomass.
#' @param SoilN A numeric value or vector for soil N content.
#' @param FertN A numeric value or vector for fertilizer N input.
#' @return A numeric vector of NUEsoil values.
#' @examples
#' PlantBM <- c(100, 120, 130)
#' SoilN <- c(20, 20, 20)
#' FertN <- 50
#' NUEsoil(PlantBM, SoilN, FertN)
#' @export
NUEsoil <- function(PlantBM, SoilN, FertN) {
  denom <- FertN + SoilN
  if (any(denom == 0)) stop("Total available N cannot be zero.")
  return(PlantBM / denom)
}