% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nd_gdd.R
\name{nd.gdd}
\alias{nd.gdd}
\title{Graph Diffusion Distance}
\usage{
nd.gdd(A, out.dist = TRUE, vect = seq(from = 0.1, to = 1, length.out = 10))
}
\arguments{
\item{A}{a list of length \eqn{N} containing adjacency matrices.}

\item{out.dist}{a logical; \code{TRUE} for computed distance matrix as a \code{dist} object.}

\item{vect}{a vector of parameters \eqn{t} whose values will be used.}
}
\value{
a named list containing \describe{
\item{D}{an \eqn{(N\times N)} matrix or \code{dist} object containing pairwise distance measures.}
\item{maxt}{an \eqn{(N\times N)} matrix whose entries are maximizer of the cost function.}
}
}
\description{
Graph Diffusion Distance (\code{nd.gdd}) quantifies the difference between two weighted graphs of same size. It takes
an idea from heat diffusion process on graphs via graph Laplacian exponential kernel matrices. For a given
adjacency matrix \eqn{A}, the graph Laplacian is defined as
\deqn{L := D-A}
where \eqn{D_{ii}=\sum_j A_{ij}}. For two adjacency matrices \eqn{A_1} and \eqn{A_2},
GDD is defined as
\deqn{d_{gdd}(A_1,A_2) = max_t \sqrt{\| \exp(-tL_1) -\exp(-tL_2)   \|_F^2}}
where \eqn{\exp(\cdot)} is matrix exponential, \eqn{\|\cdot\|_F} a Frobenius norm, and \eqn{L_1} and \eqn{L_2}
Laplacian matrices corresponding to \eqn{A_1} and \eqn{A_2}, respectively.
}
\examples{
## load data and extract a subset
data(graph20)
gr.small = graph20[c(1:5,11:15)]

## compute distance matrix
output = nd.gdd(gr.small, out.dist=FALSE)

## visualize
opar = par(no.readonly=TRUE)
par(pty="s")
image(output$D[,10:1], main="two group case", col=gray((0:32)/32), axes=FALSE)
par(opar)

}
\references{
\insertRef{hammond_graph_2013}{NetworkDistance}
}
