% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/olink_normalization_product.R
\name{olink_normalization_product_format}
\alias{olink_normalization_product_format}
\title{Formatting the output of olink_normalization_product for seamless use with
downstream analysis functions.}
\usage{
olink_normalization_product_format(
  df_norm,
  df1,
  df1_project_nr,
  df2,
  df2_project_nr,
  prod_uniq,
  lst_check
)
}
\arguments{
\item{df_norm}{A "tibble" of Olink data in long format resulting from the
olink_normalization_product function.}

\item{df1}{First dataset to be used for normalization, pre-normalization.
Must match df1 used in olink_normalization product bridging.}

\item{df1_project_nr}{Project name of first dataset. Must match name used in
olink_normalization product bridging.}

\item{df2}{Second dataset to be used for normalization, pre-normalization.
Must match df2 used in olink_normalization product bridging.}

\item{df2_project_nr}{Project name of second dataset. Must match name used in
olink_normalization product bridging.}

\item{prod_uniq}{Name of products (not_ref, ref)}

\item{lst_check}{= lst_check}
}
\value{
A "tibble" of Olink data in long format containing both input
datasets with the bridged NPX quantifications, with the above
modifications.
}
\description{
Replaces the NPX values of the non-reference project by the Median Centered
or QS Normalized NPX, according to the Bridging Recommendation. Edits the
BridgingRecommendation column to indicate whether an assay is NotBridgeable,
NotOverlapping, MedianCentering, or QuantileSmoothing bridged. Replaces
OlinkID by the concatenation of the Explore HT and Explore 3072 OlinkIDs to
record the OlinkIDs from both projects for bridgeable assays. Assays that are
NotBridgeable or NotOverlapping retain their original non-reference OlinkIDs
and NPX values. Replaces SampleID with the concatenation of SampleID and
Project to make unique sample IDs for downstream analysis. Removes internal
and external controls. Removes  MedianCenteredNPX, QSNormalizedNPX,
OlinkID_E3072 columns.
}
\examples{
\donttest{
# bridge samples
bridge_samples <- intersect(
  x = unique(OlinkAnalyze:::data_ht_small$SampleID),
  y = unique(OlinkAnalyze:::data_3k_small$SampleID)
) |>
  (\(x) x[!grepl("CONTROL", x)])()

# run olink_normalization
df_norm <- olink_normalization(
  df1 = OlinkAnalyze:::data_ht_small,
  df2 = OlinkAnalyze:::data_3k_small,
  overlapping_samples_df1 = bridge_samples,
  df1_project_nr = "Explore HT",
  df2_project_nr = "Explore 3072",
  reference_project = "Explore HT"
)

# generate lst_check
lst_check_3k_ht <- OlinkAnalyze:::olink_norm_input_check(
 df1 = OlinkAnalyze:::data_ht_small,
 df2 = OlinkAnalyze:::data_3k_small,
 overlapping_samples_df1 = bridge_samples,
 overlapping_samples_df2 = NULL,
 df1_project_nr = "Explore HT",
 df2_project_nr = "Explore 3072",
 reference_project = "Explore HT",
 reference_medians = NULL
 )

# format output
OlinkAnalyze:::olink_normalization_product_format(
  df_norm = df_norm,
  df1 = OlinkAnalyze:::data_ht_small,
  df2 = OlinkAnalyze:::data_3k_small,
  df1_project_nr = "Explore HT",
  df2_project_nr = "Explore 3072",
  lst_check = lst_check_3k_ht,
  prod_uniq = c("3k", "HT")
)
}

}
\author{
Danai G. Topouza
Klev Diamanti
}
