% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Volcano_plot.R
\name{olink_volcano_plot}
\alias{olink_volcano_plot}
\title{Easy volcano plot with Olink theme}
\usage{
olink_volcano_plot(p.val_tbl, x_lab = "Estimate", olinkid_list = NULL, ...)
}
\arguments{
\item{p.val_tbl}{a data frame of results generated by olink_ttest()}

\item{x_lab}{Optional. Character value to use as the X-axis label}

\item{olinkid_list}{Optional. Character vector of proteins (by OlinkID) to label in the plot. If not provided, default is to label all significant proteins.}

\item{...}{Optional. Additional arguments for  olink_color_discrete()}
}
\value{
An object of class "ggplot", plotting significance (y-axis) by estimated difference between groups (x-axis) for each protein.
}
\description{
Generates a volcano plot using the results of the olink_ttest function using ggplot and ggplot2::geom_point.
The estimated difference is plotted on the x-axis and the negative 10-log p-value on the y-axis.
The horizontal dotted line indicates p-value=0.05.
Dots are colored based on the Benjamini-Hochberg adjusted p-value cutoff 0.05 and can optionally be annotated by OlinkID.
}
\examples{
\donttest{

library(dplyr)

npx_df <- npx_data1 \%>\% filter(!grepl('control',SampleID, ignore.case = TRUE))
ttest_results <- olink_ttest(df=npx_df,
                             variable = 'Treatment',
                             alternative = 'two.sided')
olink_volcano_plot(ttest_results)}
}
