% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/olink_normalization_format.R
\name{olink_normalization_format}
\alias{olink_normalization_format}
\title{Format the output of olink_normalization for seamless use with downstream
analysis functions.}
\usage{
olink_normalization_format(df_norm, lst_check)
}
\arguments{
\item{df_norm}{A "tibble" of Olink data in long format resulting from the
\code{olink_normalization} function.}

\item{lst_check}{Normalization input list checks generated by
\code{olink_norm_input_check}.}
}
\value{
A "tibble" of Olink data in long format containing both input
datasets with the bridged NPX quantifications, with the above
modifications.
}
\description{
For within-product bridging and subset normalization:
\itemize{
\item Adds non-overlapping assays between projects to the bridged file without
adjustment.
\item Removes external controls, except sample controls.
}

For cross-product bridging:
\itemize{
\item Adds non-overlapping assays between projects and not bridgeable assays to
the bridged file without adjustment.
\item Removes external controls, except sample controls.
\item Replaces the NPX values of the non-reference project by the Median Centered
or QS Normalized NPX, according to the Bridging Recommendation.
\item Edits the BridgingRecommendation column to indicate whether an assay is
NotBridgeable, NotOverlapping, MedianCentering, or QuantileSmoothing bridged.
\item Replaces OlinkID by the concatenation of each product's OlinkIDs to
record the OlinkIDs from both projects for bridgeable assays. Assays that
are NotBridgeable or NotOverlapping retain their original OlinkIDs and NPX
values.
\item Replaces Panel by the concatenation of each product panel per assay. Assays
that are NotBridgeable or NotOverlapping retain their original Panel value.
\item Removes  MedianCenteredNPX, QSNormalizedNPX, OlinkID_E3072 columns.
}

#' For reference median normalization:
\itemize{
\item Adds non-overlapping assays from the dataset, but not from the reference
medians,  to the bridged file without adjustment.
\item Removes external controls, except sample controls.
}

In all cases, normalization and formatting changes are applied to the NPX
column. The contents of the Count and PCNormalizedNPX columns remain
unchanged.
}
\examples{
\donttest{
# bridge samples
bridge_samples <- intersect(
  x = unique(OlinkAnalyze:::data_ht_small$SampleID),
  y = unique(OlinkAnalyze:::data_3k_small$SampleID)
) |>
  (\(x) x[!grepl("CONTROL", x)])()

# run olink_normalization
df_norm <- olink_normalization(
  df1 = OlinkAnalyze:::data_ht_small,
  df2 = OlinkAnalyze:::data_3k_small,
  overlapping_samples_df1 = bridge_samples,
  df1_project_nr = "Explore HT",
  df2_project_nr = "Explore 3072",
  reference_project = "Explore HT"
)

# generate lst_check
lst_check <- OlinkAnalyze:::olink_norm_input_check(
  df1 = OlinkAnalyze:::data_3k_small,
  df2 = OlinkAnalyze:::data_ht_small,
  overlapping_samples_df1 = bridge_samples,
  overlapping_samples_df2 = NULL,
  df1_project_nr = "P1",
  df2_project_nr = "P2",
  reference_project = "P2",
  reference_medians = NULL
)

# format output
OlinkAnalyze:::olink_normalization_format(
  df_norm = df_norm,
  lst_check = lst_check
)
}

}
\author{
Danai G. Topouza
Klev Diamanti
}
