% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output_classes.R
\docType{class}
\name{dataset-class}
\alias{dataset-class}
\alias{show,dataset-method}
\title{Simulated data object}
\usage{
\S4method{show}{dataset}(object)
}
\arguments{
\item{object}{an object of class \code{dataset}}
}
\description{
The class \code{dataset} is a blueprint of \code{S4} objects that store
the result of simulation of the aggregate daily trading data.
}
\details{
\code{theoreticals} are the parameters used to generate the daily buys
and sells. \code{empiricals} are computed from the generated daily buys and sells.
If we generate data for a 60 days using \eqn{\alpha}=0.1, the most likely
outcome is to obtain 6 days (0.1 x 60) as
information event days. In this case, the theoretical value of
\eqn{\alpha}\verb{=0.1} is equal to the empirically estimated value of
\eqn{\alpha}\verb{=6/60=0.1}.
The number of generated information days can, however, be different from \code{6};
say \code{5}. In this case, empirical (actual) \eqn{\alpha} parameter derived
from the generated numbers would be \code{5/60=0.0833}, which differs from the
theoretical \eqn{\alpha}\verb{=0.1}.
The weak law of large numbers ensures the empirical parameters (\code{empiricals})
converge towards the theoretical parameters (\code{theoreticals}) when the number
of days becomes very large.
To detect the estimation biases from the models/methods, comparing the
estimates with \code{empiricals} rather than \code{theoreticals} would yield more
realistic results.
}
\section{Slots}{

\describe{
\item{\code{model}}{(\code{character}) returns the model being simulated, either \code{"MPIN"},
or \code{"adjPIN"}.}

\item{\code{days}}{(\code{numeric}) returns the length of the generated data in days.}

\item{\code{layers}}{(\code{numeric})  returns the number of information layers in the
simulated data. It takes the value \code{1} for the adjusted PIN
model, i.e. when \code{model} takes the value \code{'adjPIN'}.}

\item{\code{theoreticals}}{(\code{list}) returns the list of the theoretical parameters
used to generate the data.}

\item{\code{empiricals}}{(\code{list}) returns the list of the empirical parameters
computed from the generated data.}

\item{\code{aggregates}}{(\code{numeric}) returns an aggregation of information layers'
empirical parameters alongside with \eb and \es. The aggregated parameters
are calculated as follows:
\eqn{\alpha_{agg} = \sum \alpha_j}{}\if{html}{\eqn{\alpha*= \sum
\alpha}\subit{j}} \eqn{\delta_{agg} = \sum \alpha_j \times \delta_j}{}
\if{html}{\eqn{\delta*= \sum \alpha}\subit{j}\eqn{\delta}\subit{j}},
and \eqn{\mu_{agg} = \sum \alpha_j \times \mu_j}{}\if{html}{\eqn{\mu*= \sum
\alpha}\subit{j}\eqn{\mu}\subit{j}}.}

\item{\code{emp.pin}}{(\code{numeric}) returns the \code{PIN/MPIN/AdjPIN} value derived from
the empirically estimated parameters of the generated data.}

\item{\code{data}}{(\code{dataframe}) returns a dataframe containing the generated data.}

\item{\code{likelihood}}{(\code{numeric}) returns the value of the (log-)likelihood
function evaluated at the empirical parameters.}

\item{\code{warnings}}{(\code{character}) stores warning messages for events that occurred
during the data generation, such as conflict between two arguments.}

\item{\code{restrictions}}{(\code{list}) returns a binary list that contains the set of
parameter restrictions on the original AdjPIN model in the estimated AdjPIN
model. The restrictions are imposed equality constraints on model parameters.
If the value of the parameter  \code{restricted} is the empty list \code{(list())},
then the model has no restrictions, and the estimated model is the
unrestricted, i.e., the original AdjPIN model. If not empty, the list
contains one or multiple of the following four elements
\verb{\{theta, mu, eps, d\}}. For instance, If \code{theta} is set to \code{TRUE},
then the estimated model has assumed the equality of the probability of
liquidity shocks in no-information, and information days, i.e.,
\thetaB\code{=}\thetaS. If any of the remaining rate elements
\verb{\{mu, eps, d\}} is equal to \code{TRUE}, (say  \code{mu=TRUE}), then the
estimated model imposed equality of the concerned parameter on the buy
side, and on the sell side (\mub\code{=}\mus). If more than one element is
equal to \code{TRUE},  then the restrictions are combined. For instance,
if  the slot \code{restrictions} contains \code{list(theta=TRUE, eps=TRUE, d=TRUE)},
then the estimated AdjPIN model has three restrictions \thetaB\code{=}\thetaS,
\eb\code{=}\es, and \Db\code{=}\Ds, i.e., it has been estimated with just \code{7}
parameters, in comparison to \code{10} in the original unrestricted model.
\verb{[i]} This slot only concerns datasets generated by the function
\code{generatedata_adjpin()}.}
}}

