% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prtree_main.R
\name{pr_tree}
\alias{pr_tree}
\title{Probabilistic Regression Trees (PRTrees)}
\usage{
pr_tree(y, X, control = pr_tree_control(), ...)
}
\arguments{
\item{y}{A numeric vector for the dependent variable.}

\item{X}{A numeric matrix or data frame for the independent variables.}

\item{control}{A list of control parameters, typically created by
`pr_tree_control()`. Alternatively, control parameters can be passed
directly via the `...` argument.}

\item{...}{Control parameters to be passed to `pr_tree_control()`.
These will override any parameters specified in the `control` list.}
}
\value{
An object of class `prtree` containing the fitted model. This is a
  list with the following components

\item{yhat}{The estimated values for `y`.}

\item{XRegion}{A matrix with two columns indicating the terminal node (region)
  each observation belongs to. The first column (`TRUE`) may have `NA` for
  observations with missing values. The second column (`Internal`) shows the
  region assigned by the algorithm.}

\item{dist}{The Fortran code corresponding to the distribution used. (For
prediction purposes)}
\item{par_dist}{Parameters related to the distribution (if any).}

\item{fill_type}{Fortran code corresponding to the method used to fill the
matrix P when missing values are present.}

\item{P}{The matrix of probabilities for each terminal node.}

\item{gamma}{The values of the \eqn{\gamma_j} weights estimated for the
returned tree}

\item{MSE}{The mean squared error for the training, test/validation, and
  global datasets.}

\item{sigma}{The optimal \eqn{\sigma} vector selected by the grid search.}

\item{nodes_matrix_info}{A matrix with information for each node of the tree.}

\item{regions}{A data frame with the bounds of each variable in each node of
the returned tree.}
}
\description{
Fits a Probabilistic Regression Tree (PRTree) model. This is the
  main user-facing function of the package.
}
\examples{
set.seed(1234)
X <- matrix(runif(200, 0, 10), ncol = 1)
eps <- matrix(rnorm(200, 0, 0.05), ncol = 1)
y <- cos(X) + eps

# Fit model with custom controls passed directly
reg <- pr_tree(y, X, max_terminal_nodes = 9, perc_test = 0)

plot(
  X[order(X)], reg$yhat[order(X)],
  xlab = "x", ylab = "cos(x)", col = "blue", type = "l"
)
points(
  X[order(X)], y[order(X)],
  xlab = "x", ylab = "cos(x)", col = "red"
)

}
