% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/balance.boxplot.R
\name{boxplot.PSAboot.balance}
\alias{boxplot.PSAboot.balance}
\title{Boxplot of the balance statistics for bootstrapped samples.}
\usage{
\method{boxplot}{PSAboot.balance}(
  x,
  unadjusted.color = "red",
  pooled.color = "blue",
  point.size = 3,
  point.alpha = 0.5,
  ...
)
}
\arguments{
\item{x}{results of `[balance()]`}

\item{unadjusted.color}{the color used for the unadjusted effect size.}

\item{pooled.color}{the color used for the mean bootstrap effect size.}

\item{point.size}{the size of the points.}

\item{point.alpha}{the transparency level for the points.}

\item{...}{other parameters passed to `[facet_wrap()]`}
}
\value{
a ggplot2 expression.
}
\description{
Boxplot of the balance statistics for bootstrapped samples.
}
\examples{
\donttest{
library(PSAboot)
data(pisa.psa.cols)
data(pisausa)
bm.usa <- PSAboot(Tr = as.integer(pisausa$PUBPRIV) - 1,
    Y = pisausa$Math,
    X = pisausa[,pisa.psa.cols],
    control.ratio = 5, M = 100, seed = 2112)
bm.usa.bal <- balance(bm.usa)
boxplot(bm.usa.bal, nrow = 1)
}
}
