\name{germination_example}
\alias{germination_example}
\docType{data}
\title{Example Germination Data for PSRI Softmax Calculation}
\description{
A synthetic dataset modeled after prion-exposed germination experiments
with corn and barley. Contains time-series germination counts and
radicle emergence data across multiple treatments and replicates.
}
\usage{data(germination_example)}
\format{
  A data frame with 40 rows and 8 columns:
  \describe{
    \item{species}{Character. Crop species (\code{"corn"} or
      \code{"barley"}).}
    \item{treatment}{Character. Treatment group.}
    \item{replicate}{Integer. Replicate number (1-4).}
    \item{total_seeds}{Integer. Total seeds per replicate (25).}
    \item{day3}{Integer. Cumulative germination count at day 3.}
    \item{day5}{Integer. Cumulative germination count at day 5.}
    \item{day7}{Integer. Cumulative germination count at day 7.}
    \item{radicle_count}{Integer. Seeds with radicle emergence at day 7.}
  }
}
\source{
Synthetic data modeled after experiments at the Minnesota Center for
Prion Research and Outreach (MNPRO), University of Minnesota.
}
\examples{
data(germination_example)
head(germination_example)

# Compute PSRI_SM for first row
row1 <- germination_example[1, ]
compute_psri_sm(
  germination_counts = c(row1$day3, row1$day5, row1$day7),
  timepoints = c(3, 5, 7),
  total_seeds = row1$total_seeds,
  radicle_count = row1$radicle_count,
  return_components = TRUE
)
}
