% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/A02-estimator-cox.R
\name{surveff_cox}
\alias{surveff_cox}
\title{Wrapper for Cox Survival Effect Estimation with Variance}
\usage{
surveff_cox(
  data,
  treatment_var,
  ps_formula,
  time_var,
  event_var,
  censoring_formula,
  eval_times = NULL,
  estimand = "ATE",
  att_group = NULL,
  trim = NULL,
  delta = NULL,
  alpha = NULL,
  contrast_matrix = NULL,
  B = 100,
  parallel = FALSE,
  mc.cores = 2,
  seed = NULL,
  censoring_control = list(),
  ties = "efron",
  ps_control = list(),
  boot_level = "full"
)
}
\arguments{
\item{data}{Data frame (possibly processed by data validation).}

\item{treatment_var}{Name of treatment variable.}

\item{ps_formula}{Formula for propensity score model.}

\item{time_var}{Name of time variable.}

\item{event_var}{Name of event indicator (1 = event, 0 = censored).}

\item{censoring_formula}{Formula for censoring score model.}

\item{eval_times}{Numeric vector of time points. If NULL, uses all unique event times.}

\item{estimand}{Target estimand: "ATE", "ATT", or "overlap". Default "ATE".}

\item{att_group}{Target group for ATT (required if estimand = "ATT").}

\item{trim}{Trimming method: "symmetric" or "asymmetric". Default NULL (no trimming).}

\item{delta}{Threshold for symmetric trimming. Required if trim = "symmetric".}

\item{alpha}{Percentile for asymmetric trimming. Required if trim = "asymmetric".}

\item{contrast_matrix}{Optional matrix for treatment differences. Each row represents
one contrast with exactly two non-zero elements: -1 and 1. Column names must
match treatment levels. For binary treatment, ignored (always estimates S1-S0).
For >2 groups, required to estimate differences (otherwise returns NULL).}

\item{B}{Number of bootstrap iterations. Default 100.}

\item{parallel}{Logical. Use parallel bootstrap via \code{mclapply}. Default FALSE.}

\item{mc.cores}{Number of cores for parallel bootstrap. Default 2.}

\item{seed}{Random seed for bootstrap reproducibility. Default NULL.}

\item{censoring_control}{Control parameters for \code{coxph()}. Default \code{list()}.}

\item{ties}{Tie handling method for Cox model. Default "efron".}

\item{ps_control}{Control parameters for PS model. Default \code{list()}.}

\item{boot_level}{Bootstrap sampling level: "full" (default) or "strata".
"full" resamples from entire dataset (standard for observational studies). "strata"
resamples within each treatment group preserving group sizes (useful when treatment assignment 
follows a stratified or fixed-ratio design). Only used if \code{variance_method = "bootstrap"}.}
}
\value{
List containing:
  \item{survival_estimates}{Matrix [time x J] of survival function estimates.}
  \item{survival_variances}{Matrix [time x J] of survival function variances.}
  \item{difference_estimates}{Matrix [time x K] of treatment differences (NULL for >2 groups without contrast_matrix).}
  \item{difference_variances}{Matrix [time x K] of difference variances (NULL for >2 groups without contrast_matrix).}
  \item{eval_times}{Time points evaluated.}
  \item{treatment_levels}{Treatment level values.}
  \item{n_levels}{Number of treatment levels.}
  \item{contrast_matrix}{Contrast matrix used (NULL if not applicable).}
  \item{surv_result}{Output from \code{surv_cox()}.}
  \item{variance_method}{Always "bootstrap" for Cox-based estimation.}
  \item{boot_result}{Bootstrap results.}
}
\description{
High-level wrapper combining propensity score estimation, weighting (with optional
trimming), survival function estimation, and variance estimation using bootstrap.
Unlike Weibull-based estimation, Cox censoring scores do not support analytical
variance; bootstrap is always used.
}
\details{
This function implements the complete estimation workflow:

**Without trimming:**
1. Estimate propensity scores on full data
2. Estimate weights from PS
3. Estimate censoring scores on full data
4. Estimate survival functions
5. Estimate differences (if applicable)
6. Estimate variances using bootstrap

**With trimming:**
1. Estimate propensity scores on full data (PS_full)
2. Use PS_full to identify observations to trim
3. Re-estimate propensity scores on trimmed data (PS_trimmed)
4. Estimate weights from PS_trimmed
5. Estimate censoring scores on trimmed data
6. Estimate survival functions on trimmed data
7. Estimate differences (if applicable)
8. Estimate variances using bootstrap

**Treatment differences:**
- Binary (2 groups): Always estimates S1 - S0 (second level minus first level),
  ignoring contrast_matrix even if provided.
- Multiple groups (>2): Requires contrast_matrix to estimate differences.
  Returns NULL for difference_* if contrast_matrix not provided.

**Variance estimation for differences:**
- Binary: Differences columns in each bootstrap sample, calculates sample variance across B trials.
- Multiple groups: Always uses bootstrap method.
}
\keyword{internal}
