% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dup.R
\name{dup}
\alias{dup}
\title{Analysis of the cardinality of a key/identifier in a table}
\usage{
dup(
  tab,
  keyby = NULL,
  count_what = "rows",
  partition = NULL,
  view = TRUE,
  nb_xmpl = 51
)
}
\arguments{
\item{tab}{Either an R dataframe or a reference to a remote table ("remote table")}

\item{keyby}{(character vector) names of the column(s) considered as keys}

\item{count_what}{(character vector) defines what to count by key (by *keyby*).
'rows' to count distinct rows, otherwise the name of the columns whose distinct values are to be counted}

\item{partition}{(character vector) names of the columns by which to break down the analysis}

\item{view}{automatic opening of generated tables}

\item{nb_xmpl}{number of duplicate examples displayed in table}
}
\value{
A set of dataframes in the global environment.
* nup_r_tab: table of n-plicate counts
* nup_xmpl_dupl: table of examples of n-plicates 
* nup_xmpl_nakey: table of examples of NA keys (n-plicates with value 0)
* nup_r_tab_part: table of n-plicate counts broken down by the modalities of the `partition` columns
}
\description{
Creates multiple result tables.
The term "n-plicate" is used to generalize the notion of duplicate: a n_plicate can be a duplicate, a triplicate, etc.
}
\examples{
# Check if "name" is a unique key of the starwars table (yes !)
dup(dplyr::starwars, keyby = "name", view = FALSE)

# Check if "key" is a unique key of the basic table (no !)
basic <- data.frame("key"   = c("a", "b", "c", "d", NA, "a", "e", "f"), 
                    "value" = c(112, 117, 317,  NA,  0,  17, 117, 112))
dup(basic, keyby = "key", view = FALSE)

}
