% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-RMA.R
\name{method.RMA}
\alias{method.RMA}
\title{Random Effects Meta-Analysis Method}
\usage{
\method{method}{RMA}(method_name, data, settings)
}
\arguments{
\item{method_name}{Method name (automatically passed)}

\item{data}{Data frame with yi (effect sizes) and sei (standard errors)}

\item{settings}{List of method settings (see Details)}
}
\value{
Data frame with RMA results
}
\description{
Implements the publication bias-unadjusted random-effects meta-analysis.
}
\details{
The following settings are implemented \describe{
\item{\code{"default"}}{Restricted Maximum Likelihood estimator
(\code{method = "REML"}) with Knapp-Hartung adjustment
(\code{test = "knha"}) for a simple random effects meta-analysis
and Restricted Maximum Likelihood estimator
(\code{method = "REML"}) with t-distribution adjustment (\code{test = "t"})
and cluster robust standard errors with small-sample adjustment
(if converged, otherwise no small-sample adjustment or no cluster robust
standard errors) for a multilevel random effects meta-analysis if
\code{study_ids} is specified in the data}
}
}
\examples{
# Generate some example data
data <- data.frame(
  yi = c(0.2, 0.3, 0.1, 0.4, 0.25),
  sei = c(0.1, 0.15, 0.08, 0.12, 0.09)
)

# Apply RMA method
result <- run_method("RMA", data)
print(result)

}
\references{
\insertAllCited{}
}
