% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-trimfill.R
\name{method.trimfill}
\alias{method.trimfill}
\title{Trim-and-Fill Meta-Analysis Method}
\usage{
\method{method}{trimfill}(method_name, data, settings)
}
\arguments{
\item{method_name}{Method name (automatically passed)}

\item{data}{Data frame with yi (effect sizes) and sei (standard errors)}

\item{settings}{List of method settings (see Details.)}
}
\value{
Data frame with trim-and-fill results
}
\description{
Implements the trim-and-fill method for adjusting publication bias
in meta-analysis using the metafor package.
}
\details{
The following settings are implemented \describe{
\item{\code{"default"}}{Random effects model fitted with Restricted Maximum
Likelihood estimator (\code{method = "REML"}) with Knapp-Hartung
adjustment (\code{test = "knha"}), followed by trim-and-fill using
left-side trimming (\code{side = "left"}) and L0 estimator
(\code{estimator = "L0"}).}
}
}
\examples{
# Generate some example data
data <- data.frame(
  yi = c(0.2, 0.3, 0.1, 0.4, 0.25),
  sei = c(0.1, 0.15, 0.08, 0.12, 0.09)
)

# Apply trimfill method
result <- run_method("trimfill", data)
print(result)

}
\references{
\insertAllCited{}
}
