% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{rm_sparse_events}
\alias{rm_sparse_events}
\title{Removes events with excessive missing data}
\usage{
rm_sparse_events(
  data = data,
  BaselineWindow = NULL,
  CriticalWindow = NULL,
  BaselineRequired = NULL,
  CriticalRequired = NULL
)
}
\arguments{
\item{data}{A data table object output after having run
\code{\link{ppl_select_recorded_eye}}.}

\item{BaselineWindow}{A numeric vector of length 1 or 2 specifying the time
points of the baseline window to be examined. Providing two values indicates
the start time and the end time of the baseline, respectively. Providing a
single value (i.e., time point) assumes that every preceding time point is
part of the baseline (N.B. trials may vary in the size of the baseline
window and will result in an error).}

\item{CriticalWindow}{A numeric vector of length 1 or 2 specifying the time
points of the critical (i.e., post-stimulus) window to be examined. Providing
two values indicates the start time and the end time of the window,
respectively. Providing a single value (i.e., time point) assumes that
every subsequent time point is part of the window.}

\item{BaselineRequired}{A number indicating the percentage of data
required in the baseline to be included (i.e., drop events with less than
this amount of data).}

\item{CriticalRequired}{A number indicating the percentage of data
required in the critical window to be included (i.e., drop events with less
than this amount of data).}
}
\value{
An object of type data table as described in \link[tibble]{tibble}.
}
\description{
\code{rm_sparse_events} removes events with less data than the
specified amount.
}
\examples{
# Load example data
data("Pupilex3")

dat <- rm_sparse_events(data = Pupilex3, BaselineWindow = c(-500, 0),
                        CriticalWindow = c(200, 2000),
                        BaselineRequired = 50,
                        CriticalRequired = 50)

# Please see the vignettes for detailed example usage.
# vignette("PupilPre_Basic_Preprocessing", package="PupilPre")

}
