% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user_suppress_estimates.R
\name{suppress_estimates}
\alias{suppress_estimates}
\title{Suppress estimates based on reliability criteria}
\usage{
suppress_estimates(RSTr_obj, threshold = 0, type = c("population", "event"))
}
\arguments{
\item{RSTr_obj}{An \code{RSTr} model object.}

\item{threshold}{The population/event suppression threshold.}

\item{type}{Determines whether suppression threshold is based on population counts or event counts.}
}
\value{
An \code{RSTr} model object with suppressed estimates.
}
\description{
Generates suppressed estimates for an \code{RSTr} model object with a given relative precision and population/event threshold.
}
\details{
While the \code{threshold} argument is optional, population/event thresholds are necessary for non-restricted models. Population/event thresholds should only be omitted for restricted CAR models, such as the RCAR.
}
\examples{
std_pop <- c(113154, 100640, 95799)
data_min <- lapply(miheart, \(x) x[1:2, 1:3, 1:3])
adj_min <- list(2, 1)
on.exit(unlink(file.path(tempdir(), "test"), recursive = TRUE), add = TRUE)
mod_mst <- mstcar("test", data_min, adj_min, tempdir(), show_plots = FALSE, verbose = FALSE)
mod_mst <- suppress_estimates(mod_mst, threshold = 1000, type = "population")
estimates_table <- get_estimates(mod_mst)
}
