% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xts_helperFunctions.R
\name{getArrayThresholdExceedance}
\alias{getArrayThresholdExceedance}
\title{Get values at the input exceedance levels for the entire array by date}
\usage{
getArrayThresholdExceedance(rdfXTS, valueIn, comparison)
}
\arguments{
\item{rdfXTS}{XTS object returned by \code{\link{rdfSlotToXTS}}}

\item{valueIn}{Numeric value for the desired threshold to compare the data
against}

\item{comparison}{String 'GT' or 'LT' for a greater-than or less-than
comparison}
}
\value{
an XTS object with the frequency in which the array of traces exceed
a threshold
}
\description{
Get values at the input exceedance levels for the entire array by date
}
\examples{
pe <- RWDataPlyr:::rdfSlotToXTS(keyRdf, 'Mead.Pool Elevation')
peLT3575 <- RWDataPlyr:::getArrayThresholdExceedance(pe, 3575, 'LT')

}
\keyword{internal}
