% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{well_log}
\alias{well_log}
\title{Well Log Dataset}
\format{
A numeric vector of length 1000 with attributes:
\describe{
\item{true_changepoints}{Vector of true changepoint locations: c(200, 350, 500, 700, 850)}
\item{description}{Description of the dataset}
\item{lithologies}{Names of lithology units}
}
}
\source{
Simulated data based on typical well-log characteristics
}
\usage{
well_log
}
\description{
A simulated well-log porosity dataset with abrupt lithology changes
typical of geological formations.
}
\details{
The data simulates porosity measurements from a well log with six distinct
lithological units:
\itemize{
\item Unit 1 (1-200): Sandstone - porosity ~15\%
\item Unit 2 (201-350): Shale - porosity ~8\%
\item Unit 3 (351-500): Limestone - porosity ~20\%
\item Unit 4 (501-700): Sandstone - porosity ~12\%
\item Unit 5 (701-850): Dense Shale - porosity ~5\%
\item Unit 6 (851-1000): Sandstone - porosity ~18\%
}
}
\examples{
\donttest{
data(well_log)
result <- detect_regimes(well_log, method = "pelt", min_segment = 50)
plot(result, type = "segments")

# Compare with true lithology boundaries
true_cps <- attr(well_log, "true_changepoints")
evaluate(result, true_changepoints = true_cps)
}
}
\keyword{datasets}
