% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zcurve.R
\name{lines.zcurve_RoBMA}
\alias{lines.zcurve_RoBMA}
\title{Add Lines With Posterior Predictive Distribution of Z-Statistics}
\usage{
\method{lines}{zcurve_RoBMA}(
  x,
  conditional = FALSE,
  plot_type = "base",
  probs = c(0.025, 0.975),
  max_samples = 500,
  extrapolate = FALSE,
  plot_CI = TRUE,
  from = -6,
  to = 6,
  by = 0.05,
  length.out = NULL,
  col = if (extrapolate) "blue" else "black",
  ...
)
}
\arguments{
\item{x}{A RoBMA object}

\item{conditional}{whether conditional estimates should be
plotted. Defaults to \code{FALSE} which plots the model-averaged
estimates. Note that both \code{"weightfunction"} and
\code{"PET-PEESE"} are always ignoring the other type of
publication bias adjustment.}

\item{plot_type}{whether to use a base plot \code{"base"}
or ggplot2 \code{"ggplot"} for plotting. Defaults to
\code{"base"}.}

\item{probs}{quantiles of the posterior samples to be displayed.
Defaults to \code{c(.025, .975)}}

\item{max_samples}{Maximum number of samples from the posterior distribution
that will be used for estimating z-curve estimates.}

\item{extrapolate}{Logical indicating whether to extrapolate values beyond the observed data range.}

\item{plot_CI}{Should credible intervals be included in the plot? Defaults to TRUE.}

\item{from}{Lower bound of the z-value range for plotting. Defaults to -6.}

\item{to}{Upper bound of the z-value range for plotting. Defaults to 6.}

\item{by}{Numeric value specifying the increment for the sequence.}

\item{length.out}{Optional integer specifying the desired length of the output sequence.}

\item{col}{Color of the plotted line.}

\item{...}{Additional graphical parameters for the line and CI ribbon.
For base R lines: \code{lwd}, \code{col}, \code{lty}.
For base R ribbon: \code{alpha} (alpha transparency for the ribbon).
For ggplot2 lines: \code{linewidth}, \code{color}, \code{linetype}.
For ggplot2 ribbon: \code{alpha}.}
}
\description{
Adds lines to a plot of a fitted zcurve_RoBMA object. This function is typically used to overlay additional information or model fits on an existing plot.
}
\seealso{
\code{\link[=as_zcurve]{as_zcurve()}}, \code{\link[=plot.zcurve_RoBMA]{plot.zcurve_RoBMA()}}, \code{\link[=hist.zcurve_RoBMA]{hist.zcurve_RoBMA()}}
}
