% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rinvwishart.R
\name{rinvwishart}
\alias{rinvwishart}
\title{Generate Random Samples from the Inverse Wishart Distribution}
\usage{
rinvwishart(n = 1, v, S)
}
\arguments{
\item{n}{Integer (>=1). Number of inverse Wishart samples to generate (default = 1).}

\item{v}{Numeric (scalar). Degrees of freedom; must satisfy v > p - 1 (where p = ncol(S)).}

\item{S}{Numeric matrix (p x p). Positive-definite scale matrix.}
}
\value{
If n=1: p x p inverse Wishart sample matrix.
        If n>1: 3D array (p x p x n) of independent inverse Wishart samples.
}
\description{
Implements Bartlett decomposition to sample from the inverse Wishart distribution
IW(v, S), where v = degrees of freedom and S = scale matrix.
}
\examples{
# 1 sample from IW(v=5, S=diag(2))
set.seed(123)
Sigma <- rinvwishart(n = 1, v = 5, S = diag(2))

# 10 samples (3D array)
Sigma_arr <- rinvwishart(n = 10, v = 5, S = diag(2))

}
