% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{check_setup}
\alias{check_setup}
\title{Download and set up SHARK4R support files}
\usage{
check_setup(path, run_app = FALSE, force = FALSE, verbose = TRUE)
}
\arguments{
\item{path}{Character string giving the directory where the products folder
should be created. Must be provided by the user.}

\item{run_app}{Logical, if \code{TRUE} runs the QC Shiny app located in the
\code{products} folder after setup. Default is \code{FALSE}.}

\item{force}{Logical, if \code{TRUE} forces a re-download and overwrites
existing folder. Default is \code{FALSE}.}

\item{verbose}{Logical, if \code{TRUE} prints progress messages.
Default is \code{TRUE}.}
}
\value{
An (invisible) list with the path to the local \code{products} folder:
}
\description{
This function downloads the \code{products} folder from
the SHARK4R GitHub repository and places them in a user-specified directory.
These folders contain Shiny applications and R Markdown documents used for
quality control (QC) of SHARK data.
}
\details{
If the \code{path} folders already exist, the download will be skipped unless
\code{force = TRUE} is specified. Optionally, the function can launch the
QC Shiny app directly after setup.
}
\examples{
\donttest{
# Download support files into a temporary directory
check_setup(path = tempdir())

# Force re-download if already present
check_setup(path = tempdir(), force = TRUE)

# Download and run the QC Shiny app
if(interactive()){
 check_setup(path = tempdir(), run_app = TRUE)
}
}

}
