% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_stats.R
\name{moranI_test}
\alias{moranI_test}
\title{Moran's I Test for Spatial Autocorrelation}
\usage{
moranI_test(
  x,
  W,
  alternative = c("greater", "less", "two.sided"),
  standardize = TRUE
)
}
\arguments{
\item{x}{Numeric vector of values.}

\item{W}{Square numeric matrix of spatial weights.}

\item{alternative}{Character string specifying the alternative hypothesis.
One of "greater" (default), "less", or "two.sided".
\itemize{
  \item \code{"greater"}: Test for positive spatial autocorrelation
    (similar values cluster together)
  \item \code{"less"}: Test for negative spatial autocorrelation
    (dissimilar values are neighbors)
  \item \code{"two.sided"}: Test for any spatial autocorrelation
}}

\item{standardize}{Logical. If TRUE (default), row-standardize weights.}
}
\value{
A named numeric vector with components:
  \itemize{
    \item \code{observed}: Observed Moran's I
    \item \code{expected}: Expected Moran's I under null
    \item \code{sd}: Standard deviation under null
    \item \code{p.value}: P-value from normal approximation
  }
}
\description{
Performs a statistical test for spatial autocorrelation using Moran's I.
Returns the test statistic, expected value, standard deviation, and p-value.
}
\examples{
set.seed(42)
x <- rnorm(100)
coords <- cbind(runif(100), runif(100))

\donttest{
# Test for spatial autocorrelation (requires RANN package)
if (requireNamespace("RANN", quietly = TRUE)) {
    W <- buildSpatialNetwork(coords, method = "knn", k = 6)
    result <- moranI_test(x, W)
    print(result)
}
}

}
