% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/session_management.R
\name{s_clean_sessions}
\alias{s_clean_sessions}
\title{Clean Old SafeMapper Sessions}
\usage{
s_clean_sessions(older_than_days = 7, session_ids = NULL, status_filter = NULL)
}
\arguments{
\item{older_than_days}{Integer. Remove sessions older than this many days.}

\item{session_ids}{Character vector. Specific session IDs to remove.}

\item{status_filter}{Character vector. Remove only sessions with these statuses
("in_progress", "failed", "corrupted").}
}
\value{
Integer. Number of files removed (invisible).
}
\description{
Removes old checkpoint files to free up disk space. Can filter by age,
specific session IDs, or status.
}
\examples{
\donttest{
# Clean sessions older than 7 days
s_clean_sessions(older_than_days = 7)

# Clean only failed sessions
s_clean_sessions(status_filter = "failed")

# Clean specific sessions
s_clean_sessions(session_ids = c("session1", "session2"))
}

}
