% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{merge_dataframes}
\alias{merge_dataframes}
\title{Merge dataframes}
\usage{
merge_dataframes(
  dataframes,
  column_collision_strategy = "intersection",
  fill_value = NA
)
}
\arguments{
\item{dataframes}{A list of dataframes to merge.}

\item{column_collision_strategy}{A string specifying how to handle column collisions.
"intersection" keeps only columns present in all dataframes,
"union" includes all columns from all dataframes, filling missing values.}

\item{fill_value}{Value to fill in missing columns if \code{column_collision_strategy} is "union".}
}
\value{
Merged dataframe
}
\description{
Merges a list of dataframes by handling column collisions
through specified strategies: "intersection" or "union".
}
\keyword{internal}
