% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_skeletalvis.R
\name{search_skeletalvis}
\alias{search_skeletalvis}
\title{Search for experiments in SkeletalVis}
\usage{
search_skeletalvis(skeletalvis, search_term, columns = NULL)
}
\arguments{
\item{skeletalvis}{Folder with the SkeletalVis data}

\item{search_term}{A string representing the term to search for.}

\item{columns}{A character vector of column names to limit the search. If NULL (default), the entire table is searched.}
}
\value{
A data frame containing experiments that match the search term in the specified columns or the whole table.
}
\description{
Search for experiments matching a search term in the SkeletalVis database.
The search can be done across the entire database or specific metadata columns.
}
\examples{

skeletalvis <- load_skeletalvis(demo=TRUE)
# Search across all columns for rows containing "SOX9"
result <- search_skeletalvis(skeletalvis, "SOX9")

# Search only in the 'Perturbation' and 'Description' columns
result <- search_skeletalvis(skeletalvis, "SOX9", columns = c("Perturbation", "Description"))
}
