% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/range_offset.R
\name{range_offset}
\alias{range_offset}
\title{range offset of taxon}
\usage{
range_offset(
  t_ext,
  rate,
  adm,
  niche = trivial_niche,
  gc = trivial_gradient,
  niche_domain = "time",
  pres_potential = all_preserved,
  ctc = perfect_preservation,
  taphonomy_domain = "strat"
)
}
\arguments{
\item{t_ext}{true time of extinction}

\item{rate}{either positive number or a function. If a number, rate of fossil occurrences passed to \code{p3}, if a function passed as rate function to \code{p3_var_rate}}

\item{adm}{age-depth model}

\item{niche}{niche model, by default the trivial niche}

\item{gc}{gradient change for the niche mode, by default the trivial gradient. See \code{?apply_niche}}

\item{niche_domain}{"time" or "strat" - in which domain should the niche model be applied?}

\item{pres_potential}{preservation potential of fossils, by default all preserved (no taphonomic effects)}

\item{ctc}{change in taphonomic conditions, by default no change in conditions. See \code{?apply_taphonomy}}

\item{taphonomy_domain}{"time" or "strat" - in which domain should the taphonomic effects be applied?}
}
\value{
a named vector with two entries:
\itemize{
\item "h": distance between last occurrence and true height of extinction
\item "t": time between last occurrence and true time of extinction
}
}
\description{
Determines temporal and stratigraphic range offset, a measure of biostratigraphic precision, as a function of time of extinction, fossil abundance, stratigraphy, ecology, and taphonomy. Effectively a high-level wrapper around \code{last_occ}, \code{p3}/\code{p3_var_rate}, \code{apply_niche}, \code{apply_taphonomy} and \code{time_to_strat}/\code{strat_to_time} from the \code{admtools} package.
}
\examples{
# last occurrences 2 km from shore
h = scenarioA$h_m[,"2km"]
adm = admtools::tp_to_adm(t = scenarioA$t_myr, h = h)
offset = range_offset(t_ext = 1.8, rate = 5, adm = adm)
offset # show timing and position of last occurrences

}
\seealso{
\code{\link[=last_occ]{last_occ()}} determine position/time of last occurrence of taxon
}
