% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sc_get_data.R
\name{sc_get_nni}
\alias{sc_get_nni}
\title{Get NNI}
\usage{
sc_get_nni(
  year,
  aoi = NULL,
  comid = NULL,
  showAreaSqKm = TRUE,
  state = NULL,
  county = NULL,
  region = NULL,
  conus = NULL,
  showPctFull = NULL,
  countOnly = NULL
)
}
\arguments{
\item{year}{Years(s) of NNI metrics to query.
Only valid NNI years are accepted (1987:2017)
Syntax: year=<year1>,<year2>}

\item{aoi}{Specify the area of interest described by a metric. By default, all available areas of interest
for a given metric are returned.
Syntax: areaOfInterest=<value1>,<value2>
Values: catchment|watershed}

\item{comid}{Return metric information for specific COMIDs
Syntax: comid=<comid1>,<comid2>}

\item{showAreaSqKm}{Return the area in square kilometers of a given area of interest.
The default value is true.
Values: true|false}

\item{state}{Return metric information for COMIDs within a specific state. Use a state's abbreviation to
query for a given state.
Syntax: state=<state1>,<state2>}

\item{county}{Return metric information for COMIDs within a specific county.
Users must use the FIPS code, not county name, as a way to disambiguate counties.
Syntax: county=<county1>,<county1>}

\item{region}{Return metric information for COMIDs within a specified hydroregion.
Syntax: region=<regionid1>,<regionid2>}

\item{conus}{Return all COMIDs in the conterminous United States.
The default value is false.
Values: true|false}

\item{showPctFull}{Return the pctfull for each dataset. The default value is false.
Values: true|false}

\item{countOnly}{Return a CSV containing only the row count (ROWCOUNT) and the column
count (COLUMNCOUNT) that the server expects to return in a request. The default value is false.
Values: true|false}
}
\value{
A tibble of desired StreamCat metrics
}
\description{
Function to get all NNI data available for a given year.
}
\examples{
\dontrun{

df <- sc_get_nni(year='1987, 1990, 2005, 2017', aoi='cat,ws',
comid='179,1337,1337420')

df <- sc_get_nni(year='2015', aoi='cat',
comid='179', countOnly=TRUE)

df <- sc_get_nni(comid='179', year='2011, 2012', aoi='ws')

df <- sc_get_nni(year='2015, 2016, 2017', county='41003', aoi='ws')
}
}
\author{
Selia Markley
}
