% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.R
\name{ggml_gallocr_new}
\alias{ggml_gallocr_new}
\title{Create Graph Allocator}
\usage{
ggml_gallocr_new()
}
\value{
Graph allocator object (external pointer)
}
\description{
Creates a new graph allocator for efficient memory management.
The allocator can automatically allocate and reuse memory for graph tensors.
}
\examples{
\donttest{
ctx <- ggml_init(16 * 1024 * 1024)
galloc <- ggml_gallocr_new()

a <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 10)
b <- ggml_relu(ctx, a)
graph <- ggml_build_forward_expand(ctx, b)

# Allocate graph
ggml_gallocr_alloc_graph(galloc, graph)

ggml_gallocr_free(galloc)
ggml_free(ctx)
}
}
