% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{ggml_sum}
\alias{ggml_sum}
\title{Sum (Graph)}
\usage{
ggml_sum(ctx, a)
}
\arguments{
\item{ctx}{GGML context}

\item{a}{Input tensor}
}
\value{
Scalar tensor with the sum
}
\description{
Creates a graph node that computes the sum of all elements.
}
\examples{
\donttest{
ctx <- ggml_init(16 * 1024 * 1024)
a <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 5)
ggml_set_f32(a, c(1, 2, 3, 4, 5))
result <- ggml_sum(ctx, a)
graph <- ggml_build_forward_expand(ctx, result)
ggml_graph_compute(ctx, graph)
output <- ggml_get_f32(result)  # 15
ggml_free(ctx)
}
}
