% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log_seq.R
\name{log_seq}
\alias{log_seq}
\title{log_seq}
\usage{
log_seq(n, ln = 15, round_values = TRUE, rmv_extremes = FALSE)
}
\arguments{
\item{n}{The maximum value that the values in the sequence are scaled to.}

\item{ln}{How long the vector should be (defaults to 15).}

\item{round_values}{Option to round values to whole numbers (defaults to `TRUE`).}

\item{rmv_extremes}{Option to remove zero and the maximum value (i.e. `n`) from the beginning
and the end of the returned vector (defaults to `FALSE`). Note that this will mean the length
of the returned vector will be `n` - 2.}
}
\value{
A vector containing logarithmicly increasing values between 0 and a specified value `n`.
}
\description{
Creates a vector of logarithmicly increasing values between 0 and a specified value `n`.
If `n` is specified as 1, the vector will be scaled to between 0 and 1.
}
\examples{
# Create sequence of length 20, scaled between 0 and 500
log_seq(500,20)

# Create sequence of length 15, scaled between 0 and 1
log_seq(1,12)

}
