% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aupvb.R
\name{load_aupvb_player_info}
\alias{load_aupvb_player_info}
\title{Load cleaned aupvb player info data from the volleydata repository}
\usage{
load_aupvb_player_info(seasons = NULL)
}
\arguments{
\item{seasons}{An integer or vector of integers of seasons to fetch data for. Defaults to all available seasons.}
}
\value{
A data frame containing player information for the specified seasons.\tabular{ll}{
   Column Name \tab Type \cr
   season \tab dbl \cr
   week_number \tab dbl \cr
   game_number \tab dbl \cr
   game_date \tab chr \cr
   rank \tab dbl \cr
   rank_change \tab dbl \cr
   cumulative_podbls \tab dbl \cr
   points_this_match \tab dbl \cr
   played_this_match \tab lgl \cr
   first_name \tab chr \cr
   last_name \tab chr \cr
   uniform_number \tab dbl \cr
   sets_played \tab dbl \cr
   kills \tab dbl \cr
   kill_per_set \tab dbl \cr
   attack_attempts \tab dbl \cr
   attack_errors \tab dbl \cr
   attack_percentage \tab dbl \cr
   assists \tab dbl \cr
   assists_per_set \tab dbl \cr
   setting_errors \tab dbl \cr
   service_aces \tab dbl \cr
   service_aces_per_set \tab dbl \cr
   service_errors \tab dbl \cr
   total_reception_attempts \tab dbl \cr
   reception_errors \tab dbl \cr
   positive_reception_pct \tab dbl \cr
   digs \tab dbl \cr
   digs_per_set \tab dbl \cr
   blocks \tab dbl \cr
   blocks_per_set \tab dbl \cr
   block_assists \tab dbl \cr
   block_assists_per_set \tab dbl \cr
   primary_position_position_lk \tab chr \cr
   primary_position_description \tab chr \cr
   primary_position_short_description \tab chr \cr
   secondary_position_position_lk \tab chr \cr
   secondary_position_description \tab chr \cr
   secondary_position_short_description \tab chr \cr
   current_roster_status_lk \tab chr \cr
   current_roster_status_description \tab chr \cr
   is_home_team \tab lgl \cr
   team_color \tab chr \cr
   home_team_name \tab chr \cr
   away_team_name \tab chr \cr
   season_id \tab dbl \cr
   season_type \tab chr \cr
   player_id \tab dbl \cr
   player_slug \tab chr \cr
   uniform_number_display \tab chr \cr
   team_id \tab dbl \cr
   type \tab chr \cr
   stat_type \tab chr \cr
}
}
\description{
Load cleaned aupvb player info data from the volleydata repository
}
\examples{
try({load_aupvb_player_info(2024)})
}
